PRAGMA FOREIGN_KEYS = OFF;
BEGIN TRANSACTION;

DROP TABLE IF EXISTS MP_Implement;
DROP TABLE IF EXISTS MP_ImplementClassTypeBridge;
DROP TABLE IF EXISTS MP_ImplementSubType;
DROP TABLE IF EXISTS MP_ImplementType;
DROP TABLE IF EXISTS MP_ImplementClass;
DROP TABLE IF EXISTS MP_Machine;
DROP TABLE IF EXISTS MP_MachineClassTypeBridge;
DROP TABLE IF EXISTS MP_MachineSubType;
DROP TABLE IF EXISTS MP_MachineType;
DROP TABLE IF EXISTS MP_MachineClass;
DROP TABLE IF EXISTS MP_OemToManufacturerBridge;
DROP TABLE IF EXISTS MP_Manufacturer;
DROP TABLE IF EXISTS MP_EquipmentSection;
DROP TABLE IF EXISTS MP_Equipment;
DROP TABLE IF EXISTS MP_EquipmentClass;

CREATE TABLE MP_EquipmentClass (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_Equipment (id INTEGER PRIMARY KEY, machineId INTEGER, implementId INTEGER, name TEXT, equipmentClassId INTEGER, rightOffset INTEGER, aftOffset INTEGER, FOREIGN KEY(machineId) REFERENCES MP_Machine(id) ON DELETE CASCADE, FOREIGN KEY(implementId) REFERENCES MP_Implement(id) ON DELETE CASCADE );
CREATE TABLE MP_EquipmentSection (id INTEGER PRIMARY KEY, equipmentId INTEGER, statusId INTEGER, name TEXT, rightOffset INTEGER, aftOffset INTEGER, width INTEGER, fence INTEGER, FOREIGN KEY(equipmentId) REFERENCES MP_Equipment(id) ON DELETE CASCADE );
CREATE TABLE MP_Manufacturer (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_OemToManufacturerBridge (oemId INTEGER NOT NULL, manufacturerId INTEGER NOT NULL, PRIMARY KEY(oemId, manufacturerId), FOREIGN KEY(manufacturerId) REFERENCES MP_Manufacturer(id) );
CREATE TABLE MP_MachineClass (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_MachineType (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_MachineSubType (id INTEGER PRIMARY KEY, machineTypeId INTEGER, name TEXT, FOREIGN KEY(machineTypeId) REFERENCES MP_MachineType(id) ON DELETE CASCADE );
CREATE TABLE MP_MachineClassTypeBridge (machineClassId INTEGER NOT NULL, machineTypeId INTEGER NOT NULL, PRIMARY KEY(machineClassId, machineTypeId), FOREIGN KEY(machineClassId) REFERENCES MP_MachineClass(id) ON DELETE CASCADE, FOREIGN KEY(machineTypeId) REFERENCES MP_MachineType(id) ON DELETE CASCADE );
CREATE TABLE MP_Machine (id INTEGER PRIMARY KEY, creationId TEXT NOT NULL, revisionId TEXT NOT NULL, originationId TEXT NOT NULL, smtxMachineClassId INTEGER, machineClassId INTEGER NOT NULL, machineSubTypeId INTEGER NOT NULL, manufacturerId INTEGER NOT NULL, name TEXT, isoName TEXT, gpsAntennaHeight INTEGER, gpsAntennaRight INTEGER, gpsAntennaAft INTEGER, wheelBase INTEGER, minTurnRadius INTEGER, hitchOffsetRight INTEGER, hitchOffsetAft INTEGER, pivotToFrontAxle INTEGER, pivotToRearAxle INTEGER, vsnSettingsId INTEGER, FOREIGN KEY(machineClassId) REFERENCES MP_MachineClass(id) ON DELETE CASCADE, FOREIGN KEY(machineSubTypeId) REFERENCES MP_MachineSubType(id) ON DELETE CASCADE, FOREIGN KEY(manufacturerId) REFERENCES MP_Manufacturer(id) ON DELETE CASCADE );
CREATE TABLE MP_ImplementClass (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_ImplementType (id INTEGER PRIMARY KEY, name TEXT );
CREATE TABLE MP_ImplementSubType (id INTEGER PRIMARY KEY, implementTypeId INTEGER, name TEXT, FOREIGN KEY(implementTypeId) REFERENCES MP_ImplementType(id) ON DELETE CASCADE );
CREATE TABLE MP_ImplementClassTypeBridge (implementClassId INTEGER NOT NULL, implementTypeId INTEGER NOT NULL, PRIMARY KEY(implementClassId, implementTypeId), FOREIGN KEY(implementClassId) REFERENCES MP_ImplementClass(id) ON DELETE CASCADE, FOREIGN KEY(implementTypeId) REFERENCES MP_ImplementType(id) ON DELETE CASCADE );
CREATE TABLE MP_Implement (id INTEGER PRIMARY KEY, creationId TEXT NOT NULL, revisionId TEXT NOT NULL, originationId TEXT, implementClassId INTEGER NOT NULL, implementSubTypeId INTEGER NOT NULL, manufacturerId INTEGER NOT NULL, name TEXT, isoName TEXT, hitchTrail INTEGER, frontTongueLength INTEGER, rearTongueLength INTEGER, FOREIGN KEY(implementClassId) REFERENCES MP_ImplementClass(id) ON DELETE CASCADE, FOREIGN KEY(implementSubTypeId) REFERENCES MP_ImplementSubType(id) ON DELETE CASCADE, FOREIGN KEY(manufacturerId) REFERENCES MP_Manufacturer(id) ON DELETE CASCADE );
INSERT INTO MP_Manufacturer VALUES(1, 'CaseIH');
INSERT INTO MP_Manufacturer VALUES(2, 'AGCO');
INSERT INTO MP_Manufacturer VALUES(3, 'Hagie');
INSERT INTO MP_Manufacturer VALUES(4, 'Miller');
INSERT INTO MP_Manufacturer VALUES(8, 'Apache');
INSERT INTO MP_Manufacturer VALUES(9, 'GVM');
INSERT INTO MP_Manufacturer VALUES(14, 'Versatile');
INSERT INTO MP_Manufacturer VALUES(15, 'RBR');
INSERT INTO MP_Manufacturer VALUES(16, 'New Holland');

INSERT INTO MP_OemToManufacturerBridge VALUES(1, 1);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 2);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 3);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 4);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 8);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 9);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 14);
INSERT INTO MP_OemToManufacturerBridge VALUES(1, 15);
INSERT INTO MP_OemToManufacturerBridge VALUES(2, 2);
INSERT INTO MP_OemToManufacturerBridge VALUES(3, 1);
INSERT INTO MP_OemToManufacturerBridge VALUES(3, 4);
INSERT INTO MP_OemToManufacturerBridge VALUES(3, 16);
INSERT INTO MP_OemToManufacturerBridge VALUES(5, 8);
INSERT INTO MP_OemToManufacturerBridge VALUES(6, 4);
INSERT INTO MP_OemToManufacturerBridge VALUES(7, 14);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 1);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 2);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 3);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 4);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 8);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 9);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 14);
INSERT INTO MP_OemToManufacturerBridge VALUES(8, 15);
INSERT INTO MP_OemToManufacturerBridge VALUES(13, 15);

INSERT INTO MP_MachineClass VALUES(1, 'Self-Propelled');
INSERT INTO MP_MachineClass VALUES(2, 'Conventional');
INSERT INTO MP_MachineClass VALUES(3, 'Track');
INSERT INTO MP_MachineClass VALUES(4, 'Articulated');

INSERT INTO MP_MachineType VALUES(1, 'Applicator');
INSERT INTO MP_MachineType VALUES(4, 'Tractor');

INSERT INTO MP_MachineSubType VALUES(1, 1, 'Sprayer');
INSERT INTO MP_MachineSubType VALUES(2, 1, 'Fertilizer Spreader');
INSERT INTO MP_MachineSubType VALUES(3, 1, 'Manure Spreader');
INSERT INTO MP_MachineSubType VALUES(27, 4, 'Tractor');

INSERT INTO MP_MachineClassTypeBridge VALUES(1, 1);
INSERT INTO MP_MachineClassTypeBridge VALUES(2, 4);
INSERT INTO MP_MachineClassTypeBridge VALUES(3, 4);
INSERT INTO MP_MachineClassTypeBridge VALUES(4, 4);

INSERT INTO MP_Machine VALUES(48, '{06c80f42-987b-4865-a4b1-4341cfb22d9d}', '{b22278af-22f1-4b50-9c4c-084b3f1fd5ca}', 'RRS', 2, 1, 1, 1, 'Patriot 2230/2240/2250', 'Patriot 2230/2240/2250', 3505, 0, -3531, 3556, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(49, '{a7561034-b85a-4838-a1af-0b30dc1ac354}', '{3ff113ff-9c14-4331-9197-b7319d0dd489}', 'RRS', 2, 1, 1, 1, 'Patriot 3230/3240', 'Patriot 3230/3240', 3658, 0, -4930, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(50, '{56303e7a-7e84-4041-8171-7ce10dd3afc1}', '{00a5f056-edc3-43f4-a761-dd928e4deaf9}', 'RRS', 2, 1, 1, 1, 'Patriot 3330/3340', 'Patriot 3330/3340', 3658, 0, -4930, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(51, '{d7f7c27d-b85b-4280-8e76-e2a8a582e644}', '{32fd3935-aaa5-48dc-abe3-491497f710fd}', 'RRS', 2, 1, 1, 1, 'Patriot 4430/4440', 'Patriot 4430/4440', 3810, 0, -5352, 4064, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(55, '{8692c590-1775-42cb-9264-c7e0d36c58ab}', '{095d2087-aa5c-4090-9604-0c90e0c62123}', 'RRS', 2, 1, 1, 2, 'RoGator 1300', 'RoGator 1300', 3912, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(56, '{c9aba68e-23b9-40c2-8d4b-dd6cc0df260f}', '{c4d13b93-a016-4094-b972-df2d104284f7}', 'RRS', 1, 1, 1, 3, 'STS 10/12', 'STS 10/12', 3962, 0, -2870, 3556, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(128, '{28416fc7-06f8-4e05-8a71-d5615ff7f09b}', '{76dbe7ee-96a5-4503-a8c2-3e0b6fc3407a}', 'RRS', 2, 1, 1, 8, 'AS1020 - 50"CC', 'AS1020 - 50"CC', 3632, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(129, '{ef64dac0-3512-474b-b623-1ae611679690}', '{67491198-ac23-4a7c-8ebd-fdff50cf56f3}', 'RRS', 2, 1, 1, 8, 'AS1025 - 42"CC', 'AS1025 - 42"CC', 3429, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(130, '{5a2de39f-89f4-4d57-90a4-bf567f552eb5}', '{e103013d-aed0-41c8-be40-64d2e6b027dd}', 'RRS', 2, 1, 1, 8, 'AS1220 - 50"CC', 'AS1220 - 50"CC', 3632, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(131, '{5b4ae986-bd36-41b2-a92f-dd384f39e66b}', '{5e7f2931-f1bc-458d-8340-caecea0fd11c}', 'RRS', 2, 1, 1, 8, 'AS1025 - 50"CC', 'AS1025 - 50"CC', 3632, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(133, '{1f67d8d8-4435-477d-8c96-a5cf87cd93b4}', '{cb3eff5c-b0ff-43a6-8cff-40799e3b99bb}', 'RRS', 2, 1, 1, 8, 'AS1220 Plus - 50"CC', 'AS1220 Plus - 50"CC', 3632, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(138, '{2934b223-8db4-4591-a466-824d04b3ccc1}', '{5260c916-80dd-4379-ad01-fb92d4af65aa}', 'RRS', 1, 1, 1, 3, 'STS 12i/14/16', 'STS 12i/14/16', 3962, 0, -3531, 4216, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(139, '{79c8e1bd-4560-423e-9143-16848ba73ef9}', '{750751a6-e809-429a-ba4a-fc05e29a5e9b}', 'RRS', NULL, 1, 1, 3, 'DTS Classic', 'DTS Classic', 3429, 0, -2083, 3556, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(140, '{8a0f15e0-d20f-410b-81ba-ec891430fed1}', '{66878676-a1f4-4942-a404-43e0254b5a91}', 'RRS', NULL, 1, 1, 8, 'AS720 - 42"CC', 'AS720 - 42"CC', 3429, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(141, '{06e62aec-c77e-4b93-8e6f-9dedee999056}', '{1339ebd2-4410-4e7b-9b4f-0db05d0babaf}', 'RRS', NULL, 1, 1, 8, 'AS720 - 50"CC', 'AS720 - 50"CC', 3632, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(142, '{89a3f3f3-357e-4194-a894-141fd8f3a738}', '{04e4e10c-12cd-4c64-a8b1-56ad345bff71}', 'RRS', NULL, 1, 1, 8, 'AS1020 - 42"CC', 'AS1020 - 42"CC', 3429, 0, -3353, 4648, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(143, '{a622cbef-f70f-4d8e-9a89-936b2981a021}', '{985f49f4-db79-46ad-9a6d-582776bc0a4d}', 'RRS', NULL, 1, 1, 1, 'Titan 3000 Series', 'Titan 3000 Series', 3759, 0, -4752, 6807, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(144, '{5977d6c6-4d4c-4c40-86f2-0a3ec0c62b1f}', '{2a445d88-df21-465a-befd-9fd704a18486}', 'RRS', NULL, 1, 2, 1, 'Titan 3000 Series', 'Titan 3000 Series', 3759, 0, -4752, 6807, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(145, '{af430612-0b56-48a1-b6c7-8f4813c8ad5f}', '{7b6bc510-31a0-4356-a0b3-52dad9b6dbd3}', 'RRS', NULL, 1, 1, 1, 'Titan 4000 Series', 'Titan 4000 Series', 3607, 0, -4572, 4572, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(146, '{820f4573-6985-492e-afd2-038c3d787fb0}', '{2f98e490-9b23-46a4-b2c4-dc15145dcd1f}', 'RRS', NULL, 1, 2, 1, 'Titan 4000 Series', 'Titan 4000 Series', 3607, 0, -4572, 4572, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(147, '{6eb400d1-fe08-4c3f-a170-1e69227ec060}', '{f857a41c-a7b2-4ae5-bf49-61edf3154634}', 'RRS', NULL, 1, 1, 2, 'RoGator 700', 'RoGator 700', 4039, 51, -2210, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(148, '{745fe982-6dfb-4be2-9c96-ef5bdf0571b5}', '{aca22b08-0e5b-4edc-a230-e078497779c4}', 'RRS', NULL, 1, 1, 2, 'RoGator 900', 'RoGator 900', 3912, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(149, '{65711f7e-41a8-4f6a-bed3-1ff8564779a8}', '{3bb822fd-637e-416c-8e30-5310cdad2277}', 'RRS', NULL, 1, 1, 2, 'RoGator 1100', 'RoGator 1100', 3912, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(150, '{f9da085a-8c55-4404-8381-57601ca4ed68}', '{0bfa5705-909a-4cd5-8004-67a7312c2818}', 'RRS', NULL, 1, 2, 2, 'TerraGator 7300', 'TerraGator 7300', 3454, 25, -2845, 6934, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(151, '{29b03049-08a2-454c-bc52-29521dd38596}', '{10373fe0-8392-44b1-8003-4674c69983fe}', 'RRS', NULL, 1, 2, 2, 'TerraGator 8300', 'TerraGator 8300', 3454, 25, -2845, 6934, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(152, '{d50cbebf-afb3-4322-a044-02c3226950b5}', '{88888a2f-40c7-45c9-8907-5533ee7e6398}', 'RRS', NULL, 1, 2, 2, 'TerraGator 8400', 'TerraGator 8400', 3683, 25, -3175, 5105, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(153, '{7e844725-5056-45b6-8bf6-fac7b3ac864c}', '{a075ee4c-f21e-4146-bf1a-fd2d8c53e53a}', 'RRS', NULL, 1, 2, 2, 'TerraGator 9300', 'TerraGator 9300', 3556, 25, -3912, 6731, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(154, '{fc662f74-ebfc-4bfe-8345-b9d4f2c05d82}', '{e1e71dd7-49a6-472e-b72e-7f1b7d460dde}', 'RRS', NULL, 1, 1, 2, 'TerraGator 7300', 'TerraGator 7300', 3454, 51, -2845, 6934, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(155, '{8df26158-e07b-4166-9fa4-cc0220083170}', '{e5076c25-c23b-413e-9fb2-cc4556de3298}', 'RRS', NULL, 1, 1, 2, 'TerraGator 8300', 'TerraGator 8300', 3454, 51, -2845, 6934, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(156, '{8f768032-e77f-4747-b822-e0b68ef66447}', '{10cbd8b8-ab26-462f-9566-f062abe97b8a}', 'RRS', NULL, 1, 1, 2, 'TerraGator 8400', 'TerraGator 8400', 3683, 51, -3175, 5105, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(157, '{e5b6a8f8-d86a-4d7b-8daf-68ba1f43cc09}', '{8dda0adb-0f81-4bd5-8717-7a7d6a472917}', 'RRS', NULL, 1, 1, 2, 'TerraGator 9300', 'TerraGator 9300', 3556, 51, -3912, 6731, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(158, '{e2896e2f-9898-4cc8-8f4c-1591e6d82819}', '{754d635d-f2e3-4fab-baac-7886a87ea3fc}', 'RRS', NULL, 1, 2, 2, 'RoGator 900', 'RoGator 900', 3912, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(159, '{70f017cd-a766-48a8-9dce-2220507b3b1f}', '{260add70-7441-45c1-9943-eb3da800477d}', 'RRS', NULL, 1, 2, 2, 'RoGator 1100', 'RoGator 1100', 3912, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(160, '{0f5f86da-4953-46ae-92c6-4f62514d5d8b}', '{0028f6fb-b96c-48e8-98fc-57a471190b0f}', 'RRS', NULL, 1, 2, 2, 'RoGator 1300', 'RoGator 1300', 3900, 25, -2743, 4318, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(161, '{73cd940b-1847-4b99-8fd9-905f6d77d1ad}', '{ca560814-fb14-4c0d-963f-7b09caad8e49}', 'RRS', NULL, 1, 1, 9, 'E-275', 'E-275', 3658, 0, -2896, 4191, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(162, '{327e7850-d1a5-4678-ab70-fd81146cb628}', '{bfc7626c-4c16-4eff-aedf-ea95a957f96b}', 'RRS', NULL, 1, 2, 9, 'E-275', 'E-275', 3658, 0, -2896, 4191, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(163, '{063001b1-0f10-49c3-b3e9-b9ad22eb150f}', '{75bf482f-ef91-4fa2-aa4e-fdc331131290}', 'RRS', NULL, 1, 1, 9, 'E-325', 'E-325', 3658, 0, -2896, 4394, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(164, '{8674bc26-2994-4b20-b4a8-467a73617374}', '{ab055b18-62b2-4d08-a9d3-8f934589086e}', 'RRS', NULL, 1, 2, 9, 'E-325', 'E-325', 3658, 0, -2896, 4394, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(165, '{acaa6361-1ab9-48f7-812e-d4b9c16988ac}', '{a24f3fee-2e02-49e6-b013-d00ff50d40a4}', 'RRS', NULL, 1, 1, 9, 'E-370', 'E-370', 3658, 0, -2896, 4394, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(166, '{1c57045a-1fec-4ad5-934b-bcd5cd376758}', '{2b011b76-43a4-4f9f-b14c-90adbfe2fd45}', 'RRS', NULL, 1, 2, 9, 'E-370', 'E-370', 3658, 0, -2896, 4394, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(167, '{6b5cf3ad-adaa-4dad-b9a8-9085ee4cd4e9}', '{5cce3725-934c-4576-97cf-7020b88fcc66}', 'RRS', NULL, 1, 1, 14, 'SX 240', 'SX 240', 4140, 0, -3886, 4191, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(168, '{509ab79f-4ced-4e23-8da5-72f5e70a8c98}', '{87d9ae01-e446-4634-a326-8b14216bdd6a}', 'RRS', NULL, 1, 1, 14, 'SX 280', 'SX 280', 4140, 0, -3886, 4191, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(169, '{1c6ac537-7007-4ba6-a51e-51afa0012ea0}', '{5bb62a08-0c16-47c0-8164-85a26efee3ed}', 'RRS', NULL, 1, 2, 15, 'Vector', 'Vector', 3861, 0, -4115, 4267, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(170, '{cd1bf9d2-3941-4384-9986-2a02e5d01a35}', '{e92ed760-35e3-4f9b-be5c-ffcbbec7dfec}', 'RRS', NULL, 1, 2, 15, 'Vector LWB', 'Vector LWB', 3886, 0, -4750, 4902, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(171, '{dc36ee04-5fa3-4c5f-91ec-d3e2afd4c61d}', '{f3af5adf-8341-4220-b827-89d3b7af3142}', 'RRS', NULL, 1, 2, 15, 'Venturi', 'Venturi', 3886, 0, -4521, 4674, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(172, '{a699737a-a967-4cca-8b80-d3816f6b2536}', '{3a118271-8fa4-433c-b553-dea7d8599920}', 'RRS', NULL, 1, 1, 3, 'DTS 10', 'DTS 10', 3785, 0, -2464, 3556, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(173, '{27db6b54-6cdf-4b3a-beea-3242a108f678}', '{cd74244c-9bf6-4b2c-b14f-e593923293e1}', 'RRS', NULL, 1, 1, 1, 'Trident 5550', 'Trident', 3759, 0, -4369, 4369, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(174, '{f82247e1-71b2-465e-893c-1426c725b3fc}', '{36e07e15-6434-4c20-a67b-05548e6e20bd}', 'RRS', NULL, 1, 2, 1, 'Trident 5550', 'Trident', 3759, 0, -4369, 4369, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(179, '{4b4f1161-8808-470b-ad20-cb9ae1f840fa}', '{c3829234-be4d-49df-ae20-8a6f7ff90aa7}', 'RRS', 2, 1, 1, 1, 'Patriot 3250', 'Patriot 3250', 3658, 0, -4928, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(180, '{621604e0-902f-424e-9f54-679a29fc807f}', '{f30d0436-cfa2-4a5f-bcea-e076778bd544}', 'RRS', 2, 1, 1, 1, 'Patriot 4350', 'Patriot 4350', 3810, 0, -5715, 4064, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(181, '{50559cf8-5e13-489f-b502-1beea6ed77f1}', '{517dafb5-39ee-46ca-885f-9f0b58f3ce3b}', 'RRS', 2, 1, 1, 1, 'Patriot 4450', 'Patriot 4450', 3810, 0, -5715, 4064, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(182, '{32459311-62ea-4f50-be51-3f167402ccfe}', '{b0ba33be-cd37-4135-beb0-78937948703c}', 'RRS', 2, 1, 1, 2, 'RoGator 932', 'RoGator 932', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(183, '{817b534b-c74a-40b7-a598-93ee7837c3bd}', '{37781ef4-e6e2-4ca1-b8c1-d57f7f488e6b}', 'RRS', 2, 1, 1, 2, 'RoGator 934', 'RoGator 934', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(184, '{12c4cd78-2289-4b14-9205-a87148d2cdaf}', '{cdd182a2-344e-4913-a07e-e5dc0762a37e}', 'RRS', 2, 1, 1, 2, 'RoGator 937', 'RoGator 937', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(185, '{167bdb2f-f7de-4823-8e90-435c65852853}', '{1321f432-bae8-4a1c-8634-360059f58d34}', 'RRS', 1, 1, 1, 4, 'Nitro 7285/7310', 'Nitro 7285/7310', 4039, 0, -2515, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(186, '{f9ce175c-71f9-433c-880f-0fef34e3a0c2}', '{2ce6b89c-fafc-46b7-85c0-bbf4b2624667}', 'RRS', 1, 1, 1, 4, 'Nitro 7370/7380', 'Nitro 7370/7380', 4089, 0, -3048, 4445, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(187, '{5ccb4c3b-1727-4fb0-a0ef-7949eef80849}', '{1405b690-6724-48ac-a380-bb33d2ac384f}', 'RRS', 1, 1, 1, 4, 'Nitro 7410/7420', 'Nitro 7410/7420', 4089, 0, -3048, 4445, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(188, '{4f7c83de-0aac-44ca-91c1-96f954ddf44a}', '{79b7c134-3dee-4121-842f-1be3941232f1}', 'RRS', 1, 1, 1, 16, 'Guardian SP285F/SP310F', 'Guardian SP285F/SP310F', 4039, 0, -2515, 3810, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(189, '{dd5eca3b-cc65-4151-9e94-027c7abe789b}', '{ef99d8f8-a47e-4a77-b189-00e1e4de3519}', 'RRS', 1, 1, 1, 16, 'Guardian SP370F/SP380F', 'Guardian SP370F/SP380F', 4089, 0, -3048, 4445, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(190, '{f82154dc-9998-4710-bdcc-c0d56c6b46e9}', '{61fed6df-b561-4f00-aefd-6a0ed0cdb25d}', 'RRS', 1, 1, 1, 16, 'Guardian SP410F/SP420F', 'Guardian SP410F/SP420F', 4089, 0, -3048, 4445, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(191, '{2819cfb7-41fd-42eb-b015-8150efff1b54}', '{b22bcbae-6384-4718-8fe1-6f9a04192277}', 'RRS', NULL, 1, 2, 2, 'RoGator 932', '	RoGator 932', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(192, '{3f158da9-d031-4f0f-bc21-3ab582532bdd}', '{38408e1e-1ec1-4b5f-85bc-0359b310a028}', 'RRS', NULL, 1, 2, 2, 'RoGator 934', 'RoGator 934', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(193, '{3f282d1e-9b95-4bd4-ba3a-f6457703fc1e}', '{315827e1-163d-43fc-afcc-8508c0357b84}', 'RRS', NULL, 1, 2, 2, 'RoGator 937', 'RoGator 937', 3891, 0, -3339, 4615, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(194, '{8cdbc8ef-2c4c-4368-934f-ce967bfe589d}', '{6f16f786-be39-4e58-889b-55abf301cc73}', 'RRS', 2, 1, 1, 2, 'Massey Ferguson 525R', 'Massey Ferguson 525R', 3960, 0, -2550, 4400, 0, 0, 0, 0, 0, NULL);
INSERT INTO MP_Machine VALUES(195, '{1586726d-abbe-4f29-b4ad-309654161af5}', '{a3fd6965-b948-466a-bef3-b30b2a8b74b4}', 'RRS', 2, 1, 1, 2, 'Massey Ferguson 530R', 'Massey Ferguson 530R', 3960, 0, -2550, 4400, 0, 0, 0, 0, 0, NULL);

INSERT INTO MP_ImplementClass VALUES(1, 'Two-Wheeled Cart');
INSERT INTO MP_ImplementClass VALUES(2, 'Four-Wheeled Cart');
INSERT INTO MP_ImplementClass VALUES(3, 'Steerable Hitch');
INSERT INTO MP_ImplementClass VALUES(4, 'Mounted Toolbar');
INSERT INTO MP_ImplementClass VALUES(5, 'Pull Type Toolbar');

INSERT INTO MP_ImplementType VALUES(1, 'Pulled Type');

INSERT INTO MP_ImplementSubType VALUES(1, 1, 'Tillage');

INSERT INTO MP_ImplementClassTypeBridge VALUES(5, 1);

INSERT INTO MP_EquipmentClass VALUES(0, 'Other');
INSERT INTO MP_EquipmentClass VALUES(1, 'Spray Boom');
INSERT INTO MP_EquipmentClass VALUES(2, 'Dry Boom');
INSERT INTO MP_EquipmentClass VALUES(3, 'Nitrogen Tool Bar');
INSERT INTO MP_EquipmentClass VALUES(4, 'Spreader');
INSERT INTO MP_EquipmentClass VALUES(5, 'Planter');
INSERT INTO MP_EquipmentClass VALUES(6, 'Tillage');

INSERT INTO MP_Equipment VALUES(1, 48, NULL, '80 ft / 6 sections + fence', 1, 0, 1829);
INSERT INTO MP_Equipment VALUES(2, 48, NULL, '90 ft / 5 sections + fence', 1, 0, 1829);
INSERT INTO MP_Equipment VALUES(3, 48, NULL, '90 ft / 6 sections + fence', 1, 0, 1829);
INSERT INTO MP_Equipment VALUES(4, 49, NULL, '90 ft / 5 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(5, 49, NULL, '90 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(6, 49, NULL, '100 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(7, 50, NULL, '90 ft / 5 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(8, 50, NULL, '90 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(9, 50, NULL, '100 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(10, 50, NULL, '120 ft / 7 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(11, 51, NULL, '90 ft / 5 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(12, 51, NULL, '90 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(13, 51, NULL, '120 ft / 7 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(15, 51, NULL, '100 ft / 6 sections + fence', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(52, 128, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(53, 128, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(54, 128, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(55, 128, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(56, 128, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(57, 128, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(58, 128, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(59, 128, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(60, 128, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(61, 128, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(62, 128, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(63, 128, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(64, 128, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(65, 128, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(66, 128, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(67, 128, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(68, 128, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(69, 128, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(70, 128, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(71, 128, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(72, 128, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(73, 128, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(74, 128, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(75, 128, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(76, 128, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(77, 128, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(78, 128, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(79, 128, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(80, 129, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(81, 129, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(82, 129, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(83, 129, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(84, 129, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(85, 129, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(86, 129, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(87, 129, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(88, 129, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(89, 129, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(90, 129, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(91, 129, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(92, 129, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(93, 129, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(94, 129, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(95, 129, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(96, 129, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(97, 129, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(98, 129, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(99, 129, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(100, 129, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(101, 129, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(102, 129, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(103, 129, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(104, 129, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(105, 129, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(106, 129, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(107, 129, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(111, 130, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(112, 130, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(113, 130, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(114, 130, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(115, 130, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(116, 130, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(117, 130, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(118, 130, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(119, 130, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(120, 130, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(121, 130, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(122, 130, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(123, 130, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(124, 130, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(125, 130, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(126, 130, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(127, 130, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(128, 130, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(129, 130, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(130, 130, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(131, 130, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(132, 130, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(133, 130, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(134, 130, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(135, 130, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(136, 130, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(137, 130, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(138, 130, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(141, 131, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(142, 131, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(143, 131, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(144, 131, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(145, 131, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(146, 131, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(147, 131, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(148, 131, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(149, 131, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(150, 131, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(151, 131, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(152, 131, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(153, 131, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(154, 131, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(155, 131, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(156, 131, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(157, 131, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(158, 131, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(159, 131, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(160, 131, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(161, 131, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(162, 131, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(163, 131, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(164, 131, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(165, 131, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(166, 131, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(167, 131, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(168, 131, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(169, 133, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(170, 133, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(171, 133, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(172, 133, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(173, 133, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(174, 133, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(175, 133, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(176, 133, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(177, 133, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(178, 133, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(179, 133, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(180, 133, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(181, 133, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(182, 133, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(183, 133, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(184, 133, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(185, 133, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(186, 133, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(187, 133, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(188, 133, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(189, 133, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(190, 133, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(191, 133, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(192, 133, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(193, 133, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(194, 133, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(195, 133, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(196, 133, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(197, 48, NULL, '80 ft / 5 sections + fence', 1, 0, 1829);
INSERT INTO MP_Equipment VALUES(200, 56, NULL, '90'' / 15" / 5 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(201, 56, NULL, '90'' / 15" / 6 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(202, 56, NULL, '90'' / 15" / 7 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(203, 56, NULL, '90'' / 15" / 8 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(204, 56, NULL, '90'' / 15" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(205, 56, NULL, '90'' / 20" / 5 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(206, 56, NULL, '90'' / 20" / 6 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(207, 56, NULL, '90'' / 20" / 7 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(208, 56, NULL, '90'' / 20" / 8 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(209, 56, NULL, '90'' / 20" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(210, 56, NULL, '100'' / 15" / 5 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(211, 56, NULL, '100'' / 15" / 6 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(212, 56, NULL, '100'' / 15" / 7 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(213, 56, NULL, '100'' / 15" / 8 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(214, 56, NULL, '100'' / 15" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(215, 56, NULL, '100'' / 20" / 5 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(216, 56, NULL, '100'' / 20" / 6 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(217, 56, NULL, '100'' / 20" / 7 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(218, 56, NULL, '100'' / 20" / 8 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(219, 56, NULL, '100'' / 20" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(220, 56, NULL, '120'' / 15" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(221, 56, NULL, '120'' / 20" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(222, 56, NULL, '132'' / 22" / 9 sections', 1, 0, -6172);
INSERT INTO MP_Equipment VALUES(223, 56, NULL, '30'' NTB / 20" / 1 section', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(224, 56, NULL, '30'' NTB / 20" / 3 sections', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(225, 56, NULL, '30'' NTB / 30" / 1 section', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(226, 56, NULL, '30'' NTB / 30" / 3 sections', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(227, 56, NULL, '40'' NTB / 20" / 1 section', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(228, 56, NULL, '40'' NTB / 20" / 3 sections', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(229, 56, NULL, '40'' NTB / 30" / 1 section', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(230, 56, NULL, '40'' NTB / 30" / 3 sections', 3, 0, -5182);
INSERT INTO MP_Equipment VALUES(262, 138, NULL, '90'' / 15" / 5 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(263, 138, NULL, '90'' / 15" / 6 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(264, 138, NULL, '90'' / 15" / 7 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(265, 138, NULL, '90'' / 15" / 8 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(266, 138, NULL, '90'' / 15" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(267, 138, NULL, '90'' / 20" / 5 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(268, 138, NULL, '90'' / 20" / 6 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(269, 138, NULL, '90'' / 20" / 7 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(270, 138, NULL, '90'' / 20" / 8 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(271, 138, NULL, '90'' / 20" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(272, 138, NULL, '100'' / 15" / 5 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(273, 138, NULL, '100'' / 15" / 6 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(274, 138, NULL, '100'' / 15" / 7 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(275, 138, NULL, '100'' / 15" / 8 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(276, 138, NULL, '100'' / 15" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(277, 138, NULL, '100'' / 20" / 5 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(278, 138, NULL, '100'' / 20" / 6 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(279, 138, NULL, '100'' / 20" / 7 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(280, 138, NULL, '100'' / 20" / 8 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(281, 138, NULL, '100'' / 20" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(282, 138, NULL, '120'' / 15" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(283, 138, NULL, '120'' / 20" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(284, 138, NULL, '132'' / 22" / 9 sections', 1, 0, -6833);
INSERT INTO MP_Equipment VALUES(285, 138, NULL, '30'' NTB / 20" / 1 section', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(286, 138, NULL, '30'' NTB / 20" / 3 sections', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(287, 138, NULL, '30'' NTB / 30" / 1 section', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(288, 138, NULL, '30'' NTB / 30" / 3 sections', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(289, 138, NULL, '40'' NTB / 20" / 1 section', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(290, 138, NULL, '40'' NTB / 20" / 3 sections', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(291, 138, NULL, '40'' NTB / 30" / 1 section', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(292, 138, NULL, '40'' NTB / 30" / 3 sections', 3, 0, -5842);
INSERT INTO MP_Equipment VALUES(293, 139, NULL, '90'' / 15" / 5 sections', 1, 0, -5740);
INSERT INTO MP_Equipment VALUES(294, 140, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(295, 140, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(296, 140, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(297, 140, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(298, 140, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(299, 140, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(300, 140, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(301, 140, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(302, 140, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(303, 140, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(304, 140, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(305, 140, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(306, 140, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(307, 140, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(308, 140, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(309, 140, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(310, 140, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(311, 140, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(312, 140, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(313, 140, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(314, 140, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(315, 140, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(316, 140, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(317, 140, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(318, 140, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(319, 140, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(320, 140, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(321, 140, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(322, 141, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(323, 141, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(324, 141, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(325, 141, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(326, 141, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(327, 141, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(328, 141, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(329, 141, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(330, 141, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(331, 141, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(332, 141, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(333, 141, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(334, 141, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(335, 141, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(336, 141, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(337, 141, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(338, 141, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(339, 141, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(340, 141, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(341, 141, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(342, 141, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(343, 141, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(344, 141, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(345, 141, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(346, 141, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(347, 141, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(348, 141, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(349, 141, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(350, 142, NULL, '80''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(351, 142, NULL, '80''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(352, 142, NULL, '80''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(353, 142, NULL, '80''_15"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(354, 142, NULL, '80''_20"_7sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(355, 142, NULL, '90''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(356, 142, NULL, '90''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(357, 142, NULL, '90''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(358, 142, NULL, '90''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(359, 142, NULL, '90''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(360, 142, NULL, '90''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(361, 142, NULL, '100''_15"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(362, 142, NULL, '100''_20"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(363, 142, NULL, '100''_30"_5sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(364, 142, NULL, '100''_15"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(365, 142, NULL, '100''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(366, 142, NULL, '100''_30"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(367, 142, NULL, '120''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(368, 142, NULL, '132''_20"_9sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(369, 142, NULL, '80''_15"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(370, 142, NULL, '80''_20"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(371, 142, NULL, '80''_30"_8sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(372, 142, NULL, '90''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(373, 142, NULL, '90''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(374, 142, NULL, '90''_30"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(375, 142, NULL, '100''_15"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(376, 142, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(377, 142, NULL, '100''_20"_10sec', 1, 0, 1981);
INSERT INTO MP_Equipment VALUES(378, 144, NULL, 'FLX810 - 60ft', 2, 0, -2286);
INSERT INTO MP_Equipment VALUES(379, 144, NULL, 'FLX810 - 70ft', 2, 0, -2286);
INSERT INTO MP_Equipment VALUES(380, 143, NULL, 'FLX610-70ft/3 sec w/30"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(381, 143, NULL, 'FLX610-70ft/3 sec w/60"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(382, 143, NULL, 'FLX610-70ft/5 sec w/30"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(383, 143, NULL, 'FLX610-70ft/5 sec w/60"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(384, 143, NULL, 'FLX610-85ft/5 sec w/30"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(385, 143, NULL, 'FLX610-85ft/5 sec w/60"', 1, 0, 1702);
INSERT INTO MP_Equipment VALUES(386, 145, NULL, 'FLX610-70ft/3 sec w/30"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(387, 145, NULL, 'FLX610-70ft/3 sec w/60"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(388, 145, NULL, 'FLX610-70ft/5 sec w/30"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(389, 145, NULL, 'FLX610-70ft/5 sec w/60"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(390, 145, NULL, 'FLX610-85ft/5 sec w/30"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(391, 145, NULL, 'FLX610-85ft/5 sec w/60"', 1, 0, 1626);
INSERT INTO MP_Equipment VALUES(392, 146, NULL, 'FLX810 - 60ft', 2, 0, -2337);
INSERT INTO MP_Equipment VALUES(393, 146, NULL, 'FLX810 - 70ft', 2, 0, -2337);
INSERT INTO MP_Equipment VALUES(394, 147, NULL, '80 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(395, 147, NULL, '80 ft / 7 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(402, 147, NULL, '80 ft / 5 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(403, 147, NULL, '80 ft / 7 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(404, 147, NULL, '80 ft / 5  / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(405, 147, NULL, '80 ft / 7 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(406, 147, NULL, '80 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(407, 147, NULL, '80 ft / 7 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(408, 147, NULL, '90 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(409, 147, NULL, '90 ft / 7 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(410, 147, NULL, '90 ft / 5 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(411, 147, NULL, '90 ft / 7 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(412, 147, NULL, '90 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(413, 147, NULL, '90 ft / 7 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(414, 147, NULL, '90 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(415, 147, NULL, '90 ft / 7 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(416, 148, NULL, '90 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(417, 148, NULL, '90 ft / 5 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(418, 148, NULL, '90 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(419, 148, NULL, '90 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(420, 148, NULL, '100 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(421, 148, NULL, '100 ft / 5 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(422, 148, NULL, '100 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(423, 148, NULL, '100 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(424, 148, NULL, '120 ft / 7 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(425, 148, NULL, '120 ft / 7 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(426, 148, NULL, '120 ft / 7 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(427, 148, NULL, '120 ft / 7 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(433, 150, NULL, '70 ft / Airmax', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(434, 150, NULL, '70 ft / Airspreader', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(435, 150, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(436, 154, NULL, '70 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(437, 154, NULL, '60/80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(438, 154, NULL, '80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(441, 158, NULL, '60 ft / Airmax 180', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(442, 158, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(443, 149, NULL, '90 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(444, 149, NULL, '90 ft / 5 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(445, 149, NULL, '90 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(446, 149, NULL, '90 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(447, 149, NULL, '100 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(448, 149, NULL, '100 ft / 5 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(449, 149, NULL, '100 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(450, 149, NULL, '100 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(451, 149, NULL, '120 ft / 7 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(452, 149, NULL, '120 ft / 7 / 15" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(453, 149, NULL, '120 ft / 7 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(454, 149, NULL, '120 ft / 7 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(455, 55, NULL, '90 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(456, 55, NULL, '90 ft / 5 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(457, 55, NULL, '90 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(458, 55, NULL, '90 ft / 5 / 50 cm  Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(459, 55, NULL, '100 ft / 5 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(460, 55, NULL, '100 ft / 5 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(461, 55, NULL, '100 ft / 5 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(462, 55, NULL, '100 ft / 5 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(463, 55, NULL, '120 ft / 7 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(464, 55, NULL, '120 ft / 7 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(465, 55, NULL, '120 ft / 7 / 20" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(466, 55, NULL, '120 ft / 7 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(467, 159, NULL, '60 ft / Airmax 180', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(468, 159, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(469, 160, NULL, '60 ft / Airmax 180', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(470, 160, NULL, '90 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(471, 155, NULL, '70 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(472, 155, NULL, '60/80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(473, 155, NULL, '80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(474, 156, NULL, '70 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(475, 156, NULL, '60/80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(476, 156, NULL, '80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(477, 157, NULL, '70 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(478, 157, NULL, '60/80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(479, 157, NULL, '80 ft / 5 / 30" ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(480, 151, NULL, '70 ft / Airmax', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(481, 151, NULL, '70 ft / Airspreader', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(482, 151, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(483, 152, NULL, '70 ft / Airmax', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(484, 152, NULL, '70 ft / Airspreader', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(485, 152, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(486, 153, NULL, '70 ft / Airmax', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(487, 153, NULL, '70 ft / Airspreader', 2, 0, 1651);
INSERT INTO MP_Equipment VALUES(488, 153, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(489, 161, NULL, 'Low Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(490, 161, NULL, 'High Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(491, 161, NULL, '70/90', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(492, 161, NULL, '70/100', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(493, 161, NULL, '120', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(494, 162, NULL, 'Double Duty', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(495, 162, NULL, 'New Leader', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(496, 163, NULL, 'Low Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(497, 163, NULL, 'High Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(498, 163, NULL, '70/90', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(499, 163, NULL, '70/100', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(500, 163, NULL, '120', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(501, 165, NULL, 'Low Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(502, 165, NULL, 'High Volume 60/80', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(503, 165, NULL, '70/90', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(504, 165, NULL, '70/100', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(505, 165, NULL, '120', 0, 0, 2667);
INSERT INTO MP_Equipment VALUES(506, 164, NULL, 'Double Duty', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(507, 164, NULL, 'New Leader', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(508, 166, NULL, 'Double Duty', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(509, 166, NULL, 'New Leader', 0, 0, 1829);
INSERT INTO MP_Equipment VALUES(510, 167, NULL, '90 ft / 5 sections + fence', 1, 0, 2057);
INSERT INTO MP_Equipment VALUES(511, 167, NULL, '100 ft / 7 sections + fence', 1, 0, 2057);
INSERT INTO MP_Equipment VALUES(512, 168, NULL, '120 ft / 7 sections + fence', 1, 0, 2057);
INSERT INTO MP_Equipment VALUES(513, 168, NULL, '100 ft / 5 sections + fence', 1, 0, 2057);
INSERT INTO MP_Equipment VALUES(514, 168, NULL, '90 ft / 5 sections + fence', 1, 0, 2057);
INSERT INTO MP_Equipment VALUES(515, 147, NULL, '80 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(516, 147, NULL, '80 ft / 7 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(517, 147, NULL, '90 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(518, 147, NULL, '90 ft / 7 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(519, 147, NULL, '80 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(520, 147, NULL, '80 ft / 7 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(521, 147, NULL, '90 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(522, 147, NULL, '90 ft / 7 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(523, 147, NULL, '80 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(524, 147, NULL, '80 ft / 7 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(525, 147, NULL, '90 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(526, 147, NULL, '90 ft / 7 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(527, 147, NULL, '80 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(528, 147, NULL, '80 ft / 7 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(529, 147, NULL, '90 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(530, 147, NULL, '90 ft / 7 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(531, 148, NULL, '90 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(533, 148, NULL, '90 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(534, 148, NULL, '90 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(535, 148, NULL, '90 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(536, 148, NULL, '100 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(537, 148, NULL, '100 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(538, 148, NULL, '100 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(539, 148, NULL, '100 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(540, 148, NULL, '120 ft / 7 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(541, 148, NULL, '120 ft / 7 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(542, 148, NULL, '120 ft / 7 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(543, 148, NULL, '120 ft / 7 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(544, 149, NULL, '90 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(545, 149, NULL, '90 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(546, 149, NULL, '90 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(547, 149, NULL, '90 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(548, 149, NULL, '100 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(549, 149, NULL, '100 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(550, 149, NULL, '100 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(551, 149, NULL, '100 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(552, 149, NULL, '120 ft / 7 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(553, 149, NULL, '120 ft / 7 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(554, 149, NULL, '120 ft / 7 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(555, 149, NULL, '120 ft / 7 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(556, 55, NULL, '90 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(557, 55, NULL, '90 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(558, 55, NULL, '90 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(559, 55, NULL, '90 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(560, 55, NULL, '100 ft / 5 / 10" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(561, 55, NULL, '100 ft / 5 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(562, 55, NULL, '100 ft / 5 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(563, 55, NULL, '100 ft / 5 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(564, 55, NULL, '120 ft / 7 / 10" On / Fence Rows', 0, 0, 1651);
INSERT INTO MP_Equipment VALUES(565, 55, NULL, '120 ft / 7 / 15" On / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(566, 55, NULL, '120 ft / 7 / 20" Off / Fence Rows', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(567, 55, NULL, '120 ft / 7 / 50 cm Off / Fence Rows', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(568, 169, NULL, '13'' Bed - 60'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(569, 169, NULL, '13'' Bed - 70'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(570, 169, NULL, '13'' Bed - 80'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(571, 169, NULL, '14'' Bed - 60'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(572, 169, NULL, '14'' Bed - 70'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(573, 169, NULL, '14'' Bed - 80'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(575, 170, NULL, '13'' Bed - 60'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(576, 170, NULL, '13'' Bed - 70'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(577, 170, NULL, '13'' Bed - 80'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(578, 170, NULL, '14'' Bed - 60'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(579, 170, NULL, '14'' Bed - 70'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(580, 170, NULL, '14'' Bed - 80'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(581, 171, NULL, '13'' Bed - 60'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(582, 171, NULL, '13'' Bed - 70'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(583, 171, NULL, '13'' Bed - 80'' Spread', 4, 0, 1829);
INSERT INTO MP_Equipment VALUES(584, 171, NULL, '14'' Bed - 60'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(585, 171, NULL, '14'' Bed - 70'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(586, 171, NULL, '14'' Bed - 80'' Spread', 4, 0, 2134);
INSERT INTO MP_Equipment VALUES(587, 172, NULL, '90'' / 15" / 7 sections', 1, 0, -6147);
INSERT INTO MP_Equipment VALUES(588, 55, NULL, '90 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(589, 55, NULL, '100 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(591, 55, NULL, '120 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(592, 55, NULL, '90 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(593, 55, NULL, '100 ft / 15 / 15" Off', 0, 0, 1651);
INSERT INTO MP_Equipment VALUES(594, 55, NULL, '120 ft / 15 / 15" Off', 0, 0, 1651);
INSERT INTO MP_Equipment VALUES(596, 55, NULL, '90 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(597, 55, NULL, '100 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(598, 55, NULL, '120 ft / 16 / 20" On ', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(599, 55, NULL, '90 ft / 16 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(600, 55, NULL, '100 ft / 16 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(601, 55, NULL, '120 ft / 16 / 50 cm Off', 1, 0, 1650);
INSERT INTO MP_Equipment VALUES(603, 160, NULL, '60 ft / Spinner', 4, 0, 1651);
INSERT INTO MP_Equipment VALUES(604, 148, NULL, '90 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(605, 148, NULL, '90 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(606, 148, NULL, '90 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(607, 148, NULL, '90 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(608, 148, NULL, '100 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(609, 148, NULL, '100 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(610, 148, NULL, '100 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(611, 148, NULL, '100 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(612, 148, NULL, '120 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(613, 148, NULL, '120 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(614, 148, NULL, '120 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(615, 148, NULL, '120 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(619, 149, NULL, '90 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(620, 149, NULL, '90 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(621, 149, NULL, '90 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(622, 149, NULL, '90 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(623, 149, NULL, '100 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(624, 149, NULL, '100 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(625, 149, NULL, '100 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(626, 149, NULL, '100 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(627, 149, NULL, '120 ft / 15 / 10" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(628, 149, NULL, '120 ft / 15 / 15" Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(629, 149, NULL, '120 ft / 16 / 20" On', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(630, 149, NULL, '120 ft / 16 / 50 cm Off', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(637, 55, NULL, '120 ft / 15 / 19"', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(638, 55, NULL, '120 ft / 16 / 20" Aluminum', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(639, 55, NULL, '132 ft / 16 / 20" Aluminum', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(640, 148, NULL, '120 ft / 15 / 19"', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(641, 148, NULL, '120 ft / 16 / 20" Aluminum', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(642, 148, NULL, '132 ft / 16 / 20" Aluminum', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(643, 149, NULL, '120 ft / 15 / 19"', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(644, 149, NULL, '120 ft / 16 / 20" Aluminum', 1, 0, 1651);
INSERT INTO MP_Equipment VALUES(645, 149, NULL, '132 ft / 16 / 20" Aluminum', 1, 0, 1651);

INSERT INTO MP_EquipmentSection VALUES(2, 197, 1, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3, 197, 2, '2', -5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(4, 197, 3, '3', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(5, 197, 4, '4', 5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(6, 1, 0, 'L', -12573, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(7, 1, 1, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(8, 1, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(9, 1, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(10, 1, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(11, 1, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(12, 2, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(13, 2, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(14, 2, 2, '2', -5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(15, 2, 3, '3', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(16, 2, 4, '4', 5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(17, 3, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(18, 3, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(19, 3, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(20, 3, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(21, 3, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(22, 3, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(23, 4, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(24, 4, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(25, 4, 2, '2', -5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(26, 4, 3, '3', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(27, 4, 4, '4', 5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(28, 4, 5, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(29, 4, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(69, 12, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(70, 12, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(71, 12, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(72, 12, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(73, 12, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(74, 12, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(75, 13, 0, 'L', -18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(76, 13, 1, '1', -16002, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(77, 13, 2, '2', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(78, 13, 3, '3', -5588, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(79, 13, 4, '4', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(80, 13, 5, '5', 5588, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(88, 15, 0, 'L', -15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(89, 15, 1, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(90, 15, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(91, 15, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(92, 15, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(93, 15, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(94, 15, 6, '6', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(95, 15, 8, 'R', 15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(126, 197, 5, '5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(127, 197, 8, 'R', 12573, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(128, 1, 6, '6', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(129, 1, 8, 'R', 12573, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(130, 2, 5, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(131, 2, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(132, 3, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(133, 3, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(134, 5, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(135, 5, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(136, 5, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(137, 5, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(138, 5, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(139, 5, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(140, 5, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(141, 5, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(142, 6, 0, 'L', -15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(143, 6, 1, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(144, 6, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(145, 6, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(146, 6, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(147, 6, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(148, 6, 6, '6', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(149, 7, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(150, 7, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(151, 7, 2, '2', -5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(152, 7, 3, '3', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(153, 7, 4, '4', 5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(154, 7, 5, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(155, 7, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(156, 8, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(157, 8, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(158, 8, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(159, 8, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(160, 8, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(161, 8, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(162, 8, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(163, 8, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(164, 9, 0, 'L', -15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(165, 9, 1, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(166, 9, 2, '2', -6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(167, 9, 3, '3', -2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(168, 9, 4, '4', 2286, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(169, 9, 5, '5', 6858, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(170, 9, 6, '6', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(171, 9, 8, 'R', 15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(172, 10, 0, 'L', -18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(173, 10, 1, '1', -16002, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(174, 10, 2, '2', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(175, 10, 3, '3', -5588, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(176, 10, 4, '4', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(177, 10, 5, '5', 5588, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(178, 10, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(179, 10, 7, '7', 16002, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(180, 10, 8, 'R', 18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(181, 11, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(182, 11, 1, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(183, 11, 2, '2', -5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(184, 11, 3, '3', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(185, 11, 4, '4', 5334, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(186, 11, 5, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(187, 11, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(188, 12, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(189, 12, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(190, 13, 6, '6', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(191, 13, 7, '7', 16002, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(192, 13, 8, 'R', 18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(198, 169, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(199, 169, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(200, 169, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(201, 169, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(202, 169, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(203, 170, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(204, 170, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(205, 170, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(206, 170, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(207, 170, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(208, 171, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(209, 171, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(210, 171, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(211, 171, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(212, 171, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(213, 172, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(214, 172, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(215, 172, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(216, 172, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(217, 172, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(218, 172, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(219, 172, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(220, 173, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(221, 173, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(222, 173, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(223, 173, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(224, 173, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(225, 173, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(226, 173, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(227, 174, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(228, 174, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(229, 174, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(230, 174, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(231, 174, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(232, 175, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(233, 175, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(234, 175, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(235, 175, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(236, 175, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(237, 176, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(238, 176, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(239, 176, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(240, 176, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(241, 176, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(242, 177, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(243, 177, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(244, 177, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(245, 177, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(246, 177, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(247, 177, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(248, 177, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(249, 177, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(250, 177, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(251, 178, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(252, 178, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(253, 178, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(254, 178, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(255, 178, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(256, 178, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(257, 178, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(258, 178, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(259, 178, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(260, 179, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(261, 179, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(262, 179, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(263, 179, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(264, 179, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(265, 179, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(266, 179, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(267, 179, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(268, 179, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(269, 180, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(270, 180, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(271, 180, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(272, 180, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(273, 180, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(274, 181, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(275, 181, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(276, 181, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(277, 181, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(278, 181, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(279, 182, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(280, 182, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(281, 182, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(282, 182, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(283, 182, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(284, 183, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(285, 183, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(286, 183, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(287, 183, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(288, 183, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(289, 183, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(290, 183, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(291, 183, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(292, 183, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(293, 184, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(294, 184, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(295, 184, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(296, 184, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(297, 184, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(298, 184, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(299, 184, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(300, 184, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(301, 184, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(302, 185, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(303, 185, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(304, 185, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(305, 185, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(306, 185, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(307, 185, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(308, 185, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(309, 185, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(310, 185, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(311, 186, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(312, 186, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(313, 186, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(314, 186, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(315, 186, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(316, 186, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(317, 186, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(318, 186, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(319, 186, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(320, 187, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(321, 187, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(322, 187, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(323, 187, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(324, 187, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(325, 187, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(326, 187, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(327, 187, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(328, 187, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(329, 188, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(330, 188, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(331, 188, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(332, 188, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(333, 188, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(335, 188, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(336, 188, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(337, 188, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(338, 189, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(339, 189, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(340, 189, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(341, 189, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(342, 189, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(343, 189, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(344, 189, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(345, 189, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(346, 190, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(347, 190, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(348, 190, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(349, 190, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(350, 190, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(351, 190, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(352, 190, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(353, 190, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(354, 191, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(355, 191, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(356, 191, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(357, 191, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(358, 191, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(359, 191, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(360, 191, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(361, 191, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(362, 191, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(363, 191, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(364, 192, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(365, 192, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(366, 192, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(367, 192, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(368, 192, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(369, 192, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(370, 192, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(371, 192, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(372, 192, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(373, 192, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(374, 193, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(375, 193, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(376, 193, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(377, 193, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(378, 193, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(379, 193, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(380, 193, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(381, 193, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(382, 193, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(383, 193, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(384, 194, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(385, 194, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(386, 194, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(387, 194, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(388, 194, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(389, 194, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(390, 194, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(391, 194, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(392, 194, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(393, 194, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(394, 195, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(395, 195, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(396, 195, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(397, 195, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(398, 195, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(399, 195, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(400, 195, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(401, 195, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(402, 195, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(403, 195, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(404, 196, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(405, 196, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(406, 196, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(407, 196, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(408, 196, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(409, 196, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(410, 196, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(411, 196, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(412, 196, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(413, 196, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(414, 52, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(415, 52, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(416, 52, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(417, 52, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(418, 52, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(419, 53, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(420, 53, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(421, 53, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(422, 53, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(423, 53, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(424, 54, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(425, 54, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(426, 54, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(427, 54, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(428, 54, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(429, 55, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(430, 55, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(431, 55, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(432, 55, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(433, 55, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(434, 55, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(435, 55, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(436, 56, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(437, 56, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(438, 56, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(439, 56, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(440, 56, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(441, 56, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(442, 56, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(443, 57, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(444, 57, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(445, 57, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(446, 57, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(447, 57, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(448, 58, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(449, 58, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(450, 58, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(451, 58, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(452, 58, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(453, 59, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(454, 59, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(455, 59, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(456, 59, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(457, 59, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(458, 60, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(459, 60, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(460, 60, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(461, 60, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(462, 60, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(463, 60, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(464, 60, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(465, 60, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(466, 60, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(467, 61, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(468, 61, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(469, 61, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(470, 61, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(471, 61, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(472, 61, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(473, 61, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(474, 61, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(475, 61, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(476, 62, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(477, 62, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(478, 62, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(479, 62, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(480, 62, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(481, 62, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(482, 62, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(483, 62, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(484, 62, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(485, 63, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(486, 63, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(487, 63, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(488, 63, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(489, 63, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(490, 64, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(491, 64, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(492, 64, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(493, 64, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(494, 64, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(495, 65, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(496, 65, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(497, 65, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(498, 65, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(499, 65, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(500, 66, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(501, 66, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(502, 66, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(503, 66, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(504, 66, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(505, 66, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(506, 66, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(507, 66, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(508, 66, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(509, 67, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(510, 67, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(511, 67, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(512, 67, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(513, 67, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(514, 67, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(515, 67, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(516, 67, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(517, 67, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(518, 68, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(519, 68, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(520, 68, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(521, 68, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(522, 68, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(523, 68, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(524, 68, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(525, 68, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(526, 68, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(527, 69, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(528, 69, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(529, 69, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(530, 69, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(531, 69, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(532, 69, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(533, 69, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(534, 69, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(535, 69, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(536, 70, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(537, 70, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(538, 70, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(539, 70, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(540, 70, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(541, 70, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(542, 70, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(543, 70, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(544, 70, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(545, 71, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(546, 71, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(547, 71, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(548, 71, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(549, 71, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(551, 71, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(552, 71, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(553, 71, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(554, 72, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(555, 72, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(556, 72, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(557, 72, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(558, 72, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(559, 72, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(560, 72, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(561, 72, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(562, 73, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(563, 73, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(564, 73, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(565, 73, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(566, 73, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(567, 73, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(568, 73, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(569, 73, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(570, 74, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(571, 74, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(572, 74, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(573, 74, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(574, 74, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(575, 74, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(576, 74, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(577, 74, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(578, 74, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(579, 74, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(580, 75, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(581, 75, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(582, 75, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(583, 75, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(584, 75, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(585, 75, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(586, 75, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(587, 75, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(588, 75, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(589, 75, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(590, 76, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(591, 76, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(592, 76, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(593, 76, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(594, 76, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(595, 76, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(596, 76, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(597, 76, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(598, 76, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(599, 76, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(600, 77, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(601, 77, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(602, 77, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(603, 77, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(604, 77, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(605, 77, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(606, 77, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(607, 77, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(608, 77, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(609, 77, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(610, 78, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(611, 78, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(612, 78, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(613, 78, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(614, 78, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(615, 78, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(616, 78, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(617, 78, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(618, 78, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(619, 78, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(620, 79, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(621, 79, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(622, 79, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(623, 79, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(624, 79, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(625, 79, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(626, 79, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(627, 79, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(628, 79, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(629, 79, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(630, 80, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(631, 80, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(632, 80, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(633, 80, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(634, 80, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(635, 81, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(636, 81, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(637, 81, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(638, 81, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(639, 81, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(640, 82, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(641, 82, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(642, 82, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(643, 82, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(644, 82, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(645, 83, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(646, 83, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(647, 83, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(648, 83, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(649, 83, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(650, 83, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(651, 83, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(652, 84, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(653, 84, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(654, 84, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(655, 84, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(656, 84, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(657, 84, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(658, 84, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(659, 85, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(660, 85, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(661, 85, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(662, 85, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(663, 85, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(664, 86, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(665, 86, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(666, 86, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(667, 86, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(668, 86, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(669, 87, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(670, 87, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(671, 87, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(672, 87, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(673, 87, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(674, 88, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(675, 88, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(676, 88, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(677, 88, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(678, 88, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(679, 88, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(680, 88, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(681, 88, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(682, 88, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(683, 89, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(684, 89, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(685, 89, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(686, 89, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(687, 89, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(688, 89, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(689, 89, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(690, 89, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(691, 89, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(692, 90, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(693, 90, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(694, 90, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(695, 90, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(696, 90, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(697, 90, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(698, 90, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(699, 90, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(700, 90, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(701, 91, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(702, 91, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(703, 91, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(704, 91, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(705, 91, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(706, 92, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(707, 92, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(708, 92, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(709, 92, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(710, 92, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(711, 93, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(712, 93, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(713, 93, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(714, 93, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(715, 93, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(716, 94, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(717, 94, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(718, 94, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(719, 94, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(720, 94, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(721, 94, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(722, 94, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(723, 94, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(724, 94, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(725, 95, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(726, 95, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(727, 95, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(728, 95, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(729, 95, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(730, 95, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(731, 95, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(732, 95, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(733, 95, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(734, 96, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(735, 96, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(736, 96, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(737, 96, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(738, 96, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(739, 96, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(740, 96, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(741, 96, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(742, 96, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(743, 97, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(744, 97, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(745, 97, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(746, 97, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(747, 97, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(748, 97, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(749, 97, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(750, 97, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(751, 97, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(752, 98, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(753, 98, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(754, 98, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(755, 98, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(756, 98, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(757, 98, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(758, 98, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(759, 98, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(760, 98, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(761, 99, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(762, 99, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(763, 99, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(764, 99, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(765, 99, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(767, 99, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(768, 99, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(769, 99, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(770, 100, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(771, 100, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(772, 100, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(773, 100, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(774, 100, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(775, 100, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(776, 100, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(777, 100, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(778, 101, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(779, 101, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(780, 101, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(781, 101, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(782, 101, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(783, 101, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(784, 101, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(785, 101, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(786, 102, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(787, 102, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(788, 102, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(789, 102, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(790, 102, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(791, 102, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(792, 102, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(793, 102, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(794, 102, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(795, 102, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(796, 103, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(797, 103, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(798, 103, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(799, 103, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(800, 103, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(801, 103, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(802, 103, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(803, 103, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(804, 103, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(805, 103, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(806, 104, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(807, 104, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(808, 104, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(809, 104, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(810, 104, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(811, 104, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(812, 104, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(813, 104, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(814, 104, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(815, 104, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(816, 105, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(817, 105, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(818, 105, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(819, 105, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(820, 105, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(821, 105, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(822, 105, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(823, 105, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(824, 105, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(825, 105, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(826, 106, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(827, 106, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(828, 106, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(829, 106, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(830, 106, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(831, 106, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(832, 106, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(833, 106, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(834, 106, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(835, 106, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(836, 107, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(837, 107, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(838, 107, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(839, 107, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(840, 107, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(841, 107, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(842, 107, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(843, 107, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(844, 107, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(845, 107, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(846, 111, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(847, 111, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(848, 111, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(849, 111, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(850, 111, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(851, 112, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(852, 112, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(853, 112, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(854, 112, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(855, 112, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(856, 113, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(857, 113, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(858, 113, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(859, 113, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(860, 113, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(861, 114, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(862, 114, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(863, 114, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(864, 114, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(865, 114, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(866, 114, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(867, 114, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(868, 115, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(869, 115, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(870, 115, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(871, 115, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(872, 115, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(873, 115, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(874, 115, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(875, 116, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(876, 116, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(877, 116, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(878, 116, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(879, 116, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(880, 117, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(881, 117, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(882, 117, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(883, 117, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(884, 117, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(885, 118, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(886, 118, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(887, 118, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(888, 118, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(889, 118, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(890, 119, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(891, 119, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(892, 119, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(893, 119, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(894, 119, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(895, 119, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(896, 119, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(897, 119, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(898, 119, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(899, 120, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(900, 120, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(901, 120, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(902, 120, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(903, 120, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(904, 120, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(905, 120, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(906, 120, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(907, 120, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(908, 121, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(909, 121, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(910, 121, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(911, 121, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(912, 121, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(913, 121, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(914, 121, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(915, 121, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(916, 121, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(917, 122, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(918, 122, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(919, 122, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(920, 122, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(921, 122, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(922, 123, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(923, 123, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(924, 123, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(925, 123, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(926, 123, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(927, 124, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(928, 124, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(929, 124, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(930, 124, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(931, 124, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(932, 125, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(933, 125, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(934, 125, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(935, 125, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(936, 125, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(937, 125, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(938, 125, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(939, 125, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(940, 125, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(941, 126, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(942, 126, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(943, 126, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(944, 126, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(945, 126, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(946, 126, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(947, 126, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(948, 126, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(949, 126, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(950, 127, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(951, 127, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(952, 127, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(953, 127, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(954, 127, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(955, 127, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(956, 127, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(957, 127, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(958, 127, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(959, 128, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(960, 128, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(961, 128, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(962, 128, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(963, 128, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(964, 128, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(965, 128, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(966, 128, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(967, 128, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(968, 129, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(969, 129, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(970, 129, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(971, 129, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(972, 129, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(973, 129, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(974, 129, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(975, 129, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(976, 129, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(977, 130, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(978, 130, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(979, 130, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(980, 130, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(981, 130, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(983, 130, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(984, 130, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(985, 130, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(986, 131, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(987, 131, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(988, 131, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(989, 131, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(990, 131, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(991, 131, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(992, 131, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(993, 131, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(994, 132, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(995, 132, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(996, 132, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(997, 132, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(998, 132, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(999, 132, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1000, 132, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1001, 132, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1002, 133, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1003, 133, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1004, 133, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1005, 133, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1006, 133, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1007, 133, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1008, 133, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1009, 133, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1010, 133, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1011, 133, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1012, 134, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1013, 134, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1014, 134, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1015, 134, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1016, 134, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1017, 134, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1018, 134, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1019, 134, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1020, 134, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1021, 134, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1022, 135, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1023, 135, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1024, 135, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1025, 135, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1026, 135, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1027, 135, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1028, 135, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1029, 135, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1030, 135, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1031, 135, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1032, 136, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1033, 136, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1034, 136, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1035, 136, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1036, 136, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1037, 136, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1038, 136, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1039, 136, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1040, 136, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1041, 136, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1042, 137, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1043, 137, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1044, 137, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1045, 137, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1046, 137, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1047, 137, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1048, 137, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1049, 137, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1050, 137, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1051, 137, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1052, 138, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1053, 138, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1054, 138, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1055, 138, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1056, 138, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1057, 138, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1058, 138, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1059, 138, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1060, 138, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1061, 138, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1062, 141, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1063, 141, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1064, 141, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1065, 141, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1066, 141, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1067, 142, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1068, 142, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1069, 142, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1070, 142, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1071, 142, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1072, 143, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1073, 143, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1074, 143, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1075, 143, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1076, 143, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1077, 144, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1078, 144, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1079, 144, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1080, 144, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1081, 144, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1082, 144, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1083, 144, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1084, 145, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1085, 145, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1086, 145, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1087, 145, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1088, 145, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1089, 145, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1090, 145, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1091, 146, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1092, 146, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1093, 146, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1094, 146, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1095, 146, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1096, 147, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1097, 147, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1098, 147, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1099, 147, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1100, 147, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1101, 148, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1102, 148, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1103, 148, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1104, 148, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1105, 148, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1106, 149, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1107, 149, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1108, 149, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1109, 149, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1110, 149, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1111, 149, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1112, 149, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1113, 149, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1114, 149, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1115, 150, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1116, 150, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1117, 150, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1118, 150, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1119, 150, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1120, 150, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1121, 150, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1122, 150, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1123, 150, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1124, 151, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1125, 151, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1126, 151, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1127, 151, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1128, 151, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1129, 151, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1130, 151, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1131, 151, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1132, 151, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1133, 152, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1134, 152, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1135, 152, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1136, 152, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1137, 152, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1138, 153, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1139, 153, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1140, 153, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(1141, 153, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1142, 153, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1143, 154, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1144, 154, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1145, 154, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1146, 154, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1147, 154, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1148, 155, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1149, 155, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1150, 155, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1151, 155, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1152, 155, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1153, 155, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1154, 155, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1155, 155, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1156, 155, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1157, 156, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1158, 156, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1159, 156, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1160, 156, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1161, 156, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1162, 156, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1163, 156, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1164, 156, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1165, 156, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1166, 157, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1167, 157, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1168, 157, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1169, 157, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1170, 157, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1171, 157, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1172, 157, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1173, 157, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1174, 157, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1175, 158, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1176, 158, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1177, 158, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1178, 158, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1179, 158, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1180, 158, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1181, 158, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1182, 158, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1183, 158, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1184, 159, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1185, 159, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1186, 159, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1187, 159, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1188, 159, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1189, 159, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1190, 159, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1191, 159, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1192, 159, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1193, 160, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1194, 160, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1195, 160, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1196, 160, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1197, 160, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1199, 160, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1200, 160, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1201, 160, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1202, 161, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1203, 161, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1204, 161, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1205, 161, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1206, 161, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1207, 161, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1208, 161, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1209, 161, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1210, 162, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1211, 162, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1212, 162, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1213, 162, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1214, 162, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1215, 162, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1216, 162, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1217, 162, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1218, 163, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1219, 163, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1220, 163, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1221, 163, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1222, 163, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1223, 163, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1224, 163, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1225, 163, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1226, 163, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1227, 163, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1228, 164, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1229, 164, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1230, 164, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1231, 164, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1232, 164, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1233, 164, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1234, 164, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1235, 164, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1236, 164, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1237, 164, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1238, 165, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1239, 165, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1240, 165, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1241, 165, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1242, 165, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1243, 165, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1244, 165, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1245, 165, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1246, 165, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1247, 165, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1248, 166, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1249, 166, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1250, 166, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1251, 166, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1252, 166, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1253, 166, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1254, 166, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1255, 166, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1256, 166, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1257, 166, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1258, 167, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1259, 167, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1260, 167, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1261, 167, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1262, 167, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1263, 167, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1264, 167, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1265, 167, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1266, 167, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1267, 167, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1268, 168, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1269, 168, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1270, 168, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1271, 168, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1272, 168, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1273, 168, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1274, 168, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1275, 168, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1276, 168, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1277, 168, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1278, 197, 0, 'L', -12573, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(1279, 6, 8, 'R', 15621, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(1280, 200, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1281, 200, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1282, 200, 2, '3', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1283, 200, 3, '4', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1284, 200, 4, '5', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1285, 201, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1286, 201, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1287, 201, 2, '3', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1288, 201, 3, '4', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1289, 201, 4, '5', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1290, 201, 5, '6', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1291, 202, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1292, 202, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1293, 202, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1294, 202, 3, '4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1295, 202, 4, '5', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1296, 202, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1297, 202, 6, '7', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1298, 203, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1299, 203, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1300, 203, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1301, 203, 3, '4', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1302, 203, 4, '5', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1303, 203, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1304, 203, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1305, 203, 7, '8', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1306, 204, 0, '1', -13049, 0, 1334, 0);
INSERT INTO MP_EquipmentSection VALUES(1307, 204, 1, '2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1308, 204, 2, '3', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1309, 204, 3, '4', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1310, 204, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1311, 204, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1312, 204, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1313, 204, 7, '8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1314, 204, 8, '9', 13049, 0, 1334, 0);
INSERT INTO MP_EquipmentSection VALUES(1315, 205, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1316, 205, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1317, 205, 2, '3', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1318, 205, 3, '4', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1319, 205, 4, '5', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1320, 206, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1321, 206, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1322, 206, 2, '3', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1323, 206, 3, '4', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1324, 206, 4, '5', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1325, 206, 5, '6', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1326, 207, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1327, 207, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1328, 207, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1329, 207, 3, '4', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1330, 207, 4, '5', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1331, 207, 5, '6', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1332, 207, 6, '7', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1333, 208, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1334, 208, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1335, 208, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1336, 208, 3, '4', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1337, 208, 4, '5', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1338, 208, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1339, 208, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1340, 208, 7, '8', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1341, 209, 0, '1', -13081, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(1342, 209, 1, '2', -10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1343, 209, 2, '3', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1344, 209, 3, '4', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1345, 209, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1346, 209, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1347, 209, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1348, 209, 7, '8', 10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1349, 209, 8, '9', 13081, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(1350, 210, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1351, 210, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1352, 210, 2, '3', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1353, 210, 3, '4', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1354, 210, 4, '5', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1355, 211, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1356, 211, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1357, 211, 2, '3', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1358, 211, 3, '4', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1359, 211, 4, '5', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1360, 211, 5, '6', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1361, 212, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1362, 212, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1363, 212, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1364, 212, 3, '4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1365, 212, 4, '5', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1366, 212, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1367, 212, 6, '7', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1368, 213, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1369, 213, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1370, 213, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1371, 213, 3, '4', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1372, 213, 4, '5', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1373, 213, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1374, 213, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1375, 213, 7, '8', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1376, 214, 0, '1', -13811, 0, 2858, 0);
INSERT INTO MP_EquipmentSection VALUES(1377, 214, 1, '2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1378, 214, 2, '3', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1379, 214, 3, '4', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1380, 214, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1381, 214, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1382, 214, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1383, 214, 7, '8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1384, 214, 8, '9', 13811, 0, 2858, 0);
INSERT INTO MP_EquipmentSection VALUES(1385, 215, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1386, 215, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1387, 215, 2, '3', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1388, 215, 3, '4', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1389, 215, 4, '5', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1390, 216, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1391, 216, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1392, 216, 2, '3', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1393, 216, 3, '4', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1394, 216, 4, '5', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1395, 216, 5, '6', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1396, 217, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1397, 217, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1398, 217, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1399, 217, 3, '4', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1400, 217, 4, '5', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1401, 217, 5, '6', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1402, 217, 6, '7', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1403, 218, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1404, 218, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1405, 218, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1406, 218, 3, '4', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1407, 218, 4, '5', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1408, 218, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1409, 218, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1410, 218, 7, '8', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1411, 219, 0, '1', -13843, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1412, 219, 1, '2', -10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1413, 219, 2, '3', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1414, 219, 3, '4', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1415, 219, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1416, 219, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1417, 219, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1418, 219, 7, '8', 10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1419, 219, 8, '9', 13843, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1420, 220, 0, '1', -16478, 0, 3620, 0);
INSERT INTO MP_EquipmentSection VALUES(1421, 220, 1, '2', -12764, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1422, 220, 2, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1423, 220, 3, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1424, 220, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1425, 220, 5, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1426, 220, 6, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1427, 220, 7, '8', 12764, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1428, 220, 8, '9', 16478, 0, 3620, 0);
INSERT INTO MP_EquipmentSection VALUES(1429, 221, 0, '1', -16637, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(1430, 221, 1, '2', -12954, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1431, 221, 2, '3', -8636, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1432, 221, 3, '4', -4064, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1433, 221, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1434, 221, 5, '6', 4064, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1435, 221, 6, '7', 8636, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1436, 221, 7, '8', 12954, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1437, 221, 8, '9', 16637, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(1438, 222, 0, '1', -18021, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1439, 222, 1, '2', -13691, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1440, 222, 2, '3', -9220, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1441, 222, 3, '4', -4191, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1442, 222, 4, '5', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1443, 222, 5, '6', 4191, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1444, 222, 6, '7', 9220, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1445, 222, 7, '8', 13691, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1446, 222, 8, '9', 18021, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1447, 223, 0, '1', 0, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(1448, 224, 0, '1', -3251, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(1449, 224, 1, '2', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1450, 224, 2, '3', 3251, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(1451, 225, 0, '1', 0, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(1452, 226, 0, '1', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1453, 226, 1, '2', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1454, 226, 2, '3', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1455, 227, 0, '1', 0, 0, 12192, 0);
INSERT INTO MP_EquipmentSection VALUES(1456, 228, 0, '1', -4013, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1457, 228, 1, '2', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1458, 228, 2, '3', 4013, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1459, 229, 0, '1', 0, 0, 12192, 0);
INSERT INTO MP_EquipmentSection VALUES(1460, 230, 0, '1', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1461, 230, 1, '2', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1462, 230, 2, '3', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1463, 262, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1464, 262, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1465, 262, 2, '3', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1466, 262, 3, '4', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1467, 262, 4, '5', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1468, 263, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1469, 263, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1470, 263, 2, '3', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1471, 263, 3, '4', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1472, 263, 4, '5', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1473, 263, 5, '6', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1474, 264, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1475, 264, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1476, 264, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1477, 264, 3, '4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1478, 264, 4, '5', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1479, 264, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1480, 264, 6, '7', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1481, 265, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1482, 265, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1483, 265, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1484, 265, 3, '4', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1485, 265, 4, '5', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1486, 265, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1487, 265, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1488, 265, 7, '8', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1489, 266, 0, '1', -13049, 0, 1334, 0);
INSERT INTO MP_EquipmentSection VALUES(1490, 266, 1, '2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1491, 266, 2, '3', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1492, 266, 3, '4', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1493, 266, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1494, 266, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1495, 266, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1496, 266, 7, '8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1497, 266, 8, '9', 13049, 0, 1334, 0);
INSERT INTO MP_EquipmentSection VALUES(1498, 267, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1499, 267, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1500, 267, 2, '3', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1501, 267, 3, '4', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1502, 267, 4, '5', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1503, 268, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1504, 268, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1505, 268, 2, '3', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1506, 268, 3, '4', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1507, 268, 4, '5', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1508, 268, 5, '6', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1509, 269, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1510, 269, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1511, 269, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1512, 269, 3, '4', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1513, 269, 4, '5', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1514, 269, 5, '6', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1515, 269, 6, '7', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1516, 270, 0, '1', -11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1517, 270, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1518, 270, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1519, 270, 3, '4', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1520, 270, 4, '5', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1521, 270, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1522, 270, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1523, 270, 7, '8', 11557, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(1524, 271, 0, '1', -13081, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(1525, 271, 1, '2', -10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1526, 271, 2, '3', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1527, 271, 3, '4', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1528, 271, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1529, 271, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1530, 271, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1531, 271, 7, '8', 10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1532, 271, 8, '9', 13081, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(1533, 272, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1534, 272, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1535, 272, 2, '3', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1536, 272, 3, '4', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1537, 272, 4, '5', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1538, 273, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1539, 273, 1, '2', -5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1540, 273, 2, '3', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1541, 273, 3, '4', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1542, 273, 4, '5', 5525, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1543, 273, 5, '6', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1544, 274, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1545, 274, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1546, 274, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1547, 274, 3, '4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1548, 274, 4, '5', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1549, 274, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1550, 274, 6, '7', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1551, 275, 0, '1', -12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1552, 275, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1553, 275, 2, '3', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1554, 275, 3, '4', -762, 0, 1905, 0);
INSERT INTO MP_EquipmentSection VALUES(1555, 275, 4, '5', 953, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1556, 275, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1557, 275, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1558, 275, 7, '8', 12287, 0, 5906, 0);
INSERT INTO MP_EquipmentSection VALUES(1559, 276, 0, '1', -13811, 0, 2858, 0);
INSERT INTO MP_EquipmentSection VALUES(1560, 276, 1, '2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1561, 276, 2, '3', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1562, 276, 3, '4', -3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1563, 276, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1564, 276, 5, '6', 3429, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1565, 276, 6, '7', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1566, 276, 7, '8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1567, 276, 8, '9', 13811, 0, 2858, 0);
INSERT INTO MP_EquipmentSection VALUES(1568, 277, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1569, 277, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1570, 277, 2, '3', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1571, 277, 3, '4', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1572, 277, 4, '5', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1573, 278, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1574, 278, 1, '2', -5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1575, 278, 2, '3', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1576, 278, 3, '4', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1577, 278, 4, '5', 5588, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(1578, 278, 5, '6', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1579, 279, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1580, 279, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1581, 279, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1582, 279, 3, '4', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1583, 279, 4, '5', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1584, 279, 5, '6', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1585, 279, 6, '7', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1586, 280, 0, '1', -12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1587, 280, 1, '2', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1588, 280, 2, '3', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1589, 280, 3, '4', -762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1590, 280, 4, '5', 1016, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(1591, 280, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1592, 280, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1593, 280, 7, '8', 12319, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(1594, 281, 0, '1', -13843, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1595, 281, 1, '2', -10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1596, 281, 2, '3', -7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1597, 281, 3, '4', -3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1598, 281, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1599, 281, 5, '6', 3556, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1600, 281, 6, '7', 7366, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1601, 281, 7, '8', 10922, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1602, 281, 8, '9', 13843, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1603, 282, 0, '1', -16478, 0, 3620, 0);
INSERT INTO MP_EquipmentSection VALUES(1604, 282, 1, '2', -12764, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1605, 282, 2, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1606, 282, 3, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1607, 282, 4, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1608, 282, 5, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1609, 282, 6, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1610, 282, 7, '8', 12764, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1611, 282, 8, '9', 16478, 0, 3620, 0);
INSERT INTO MP_EquipmentSection VALUES(1612, 283, 0, '1', -16637, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(1613, 283, 1, '2', -12954, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1614, 283, 2, '3', -8636, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1615, 283, 3, '4', -4064, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1616, 283, 4, '5', 0, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1617, 283, 5, '6', 4064, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1618, 283, 6, '7', 8636, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1619, 283, 7, '8', 12954, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1620, 283, 8, '9', 16637, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(1621, 284, 0, '1', -18021, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1622, 284, 1, '2', -13691, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1623, 284, 2, '3', -9220, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1624, 284, 3, '4', -4191, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1625, 284, 4, '5', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(1626, 284, 5, '6', 4191, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1627, 284, 6, '7', 9220, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1628, 284, 7, '8', 13691, 0, 4470, 0);
INSERT INTO MP_EquipmentSection VALUES(1629, 284, 8, '9', 18021, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1630, 285, 0, '1', 0, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(1631, 286, 0, '1', -3251, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(1632, 286, 1, '2', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1633, 286, 2, '3', 3251, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(1634, 287, 0, '1', 0, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(1635, 288, 0, '1', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1636, 288, 1, '2', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1637, 288, 2, '3', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1638, 289, 0, '1', 0, 0, 12192, 0);
INSERT INTO MP_EquipmentSection VALUES(1639, 290, 0, '1', -4013, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1640, 290, 1, '2', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1641, 290, 2, '3', 4013, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(1642, 291, 0, '1', 0, 0, 12192, 0);
INSERT INTO MP_EquipmentSection VALUES(1643, 292, 0, '1', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1644, 292, 1, '2', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1645, 292, 2, '3', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1646, 293, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1647, 293, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1648, 293, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1649, 293, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1650, 293, 4, '5', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(1651, 294, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1652, 294, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1653, 294, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1654, 294, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1655, 294, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1656, 295, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1657, 295, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1658, 295, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1659, 295, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1660, 295, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1661, 296, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1662, 296, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1663, 296, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1664, 296, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1665, 296, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1666, 297, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1667, 297, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1668, 297, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1669, 297, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1670, 297, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1671, 297, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1672, 297, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1673, 298, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1674, 298, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1675, 298, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1676, 298, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1677, 298, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1678, 298, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1679, 298, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1680, 299, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1681, 299, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1682, 299, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1683, 299, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1684, 299, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1685, 300, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1686, 300, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1687, 300, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1688, 300, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1689, 300, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1690, 301, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1691, 301, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1692, 301, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1693, 301, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1694, 301, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1695, 302, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1696, 302, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1697, 302, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1698, 302, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1699, 302, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1700, 302, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1701, 302, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1702, 302, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1703, 302, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1704, 303, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1705, 303, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1706, 303, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1707, 303, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1708, 303, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1709, 303, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1710, 303, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1711, 303, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1712, 303, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1713, 304, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1714, 304, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1715, 304, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1716, 304, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1717, 304, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1718, 304, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1719, 304, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1720, 304, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1721, 304, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1722, 305, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1723, 305, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1724, 305, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1725, 305, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1726, 305, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1727, 306, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1728, 306, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1729, 306, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(1730, 306, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1731, 306, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1732, 307, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1733, 307, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1734, 307, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1735, 307, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1736, 307, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1737, 308, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1738, 308, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1739, 308, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1740, 308, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1741, 308, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1742, 308, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1743, 308, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1744, 308, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1745, 308, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1746, 309, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1747, 309, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1748, 309, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1749, 309, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1750, 309, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1751, 309, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1752, 309, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1753, 309, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1754, 309, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1755, 310, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1756, 310, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1757, 310, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1758, 310, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1759, 310, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1760, 310, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1761, 310, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1762, 310, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1763, 310, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1764, 311, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1765, 311, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1766, 311, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1767, 311, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1768, 311, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1769, 311, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1770, 311, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1771, 311, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1772, 311, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1773, 312, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1774, 312, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1775, 312, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1776, 312, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1777, 312, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1778, 312, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1779, 312, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1780, 312, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1781, 312, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1782, 313, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1783, 313, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1784, 313, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1785, 313, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1786, 313, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1788, 313, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1789, 313, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1790, 313, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1791, 314, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1792, 314, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1793, 314, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1794, 314, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1795, 314, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1796, 314, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1797, 314, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1798, 314, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1799, 315, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1800, 315, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1801, 315, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1802, 315, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1803, 315, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1804, 315, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1805, 315, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1806, 315, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1807, 316, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1808, 316, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1809, 316, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1810, 316, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1811, 316, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1812, 316, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1813, 316, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1814, 316, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1815, 316, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1816, 316, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1817, 317, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1818, 317, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1819, 317, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1820, 317, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1821, 317, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1822, 317, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1823, 317, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1824, 317, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1825, 317, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1826, 317, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1827, 318, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1828, 318, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1829, 318, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1830, 318, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1831, 318, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1832, 318, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1833, 318, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1834, 318, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1835, 318, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1836, 318, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1837, 319, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1838, 319, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1839, 319, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1840, 319, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1841, 319, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1842, 319, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1843, 319, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1844, 319, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1845, 319, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1846, 319, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1847, 320, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1848, 320, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1849, 320, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1850, 320, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1851, 320, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1852, 320, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1853, 320, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1854, 320, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1855, 320, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1856, 320, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1857, 321, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1858, 321, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1859, 321, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1860, 321, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1861, 321, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1862, 321, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1863, 321, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1864, 321, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1865, 321, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1866, 321, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1867, 322, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1868, 322, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1869, 322, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1870, 322, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1871, 322, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1872, 323, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1873, 323, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1874, 323, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1875, 323, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1876, 323, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1877, 324, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1878, 324, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1879, 324, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1880, 324, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1881, 324, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1882, 325, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1883, 325, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1884, 325, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1885, 325, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1886, 325, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1887, 325, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1888, 325, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1889, 326, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1890, 326, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1891, 326, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1892, 326, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1893, 326, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1894, 326, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1895, 326, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1896, 327, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1897, 327, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1898, 327, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1899, 327, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1900, 327, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1901, 328, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1902, 328, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1903, 328, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1904, 328, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1905, 328, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1906, 329, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1907, 329, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1908, 329, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1909, 329, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1910, 329, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1911, 330, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1912, 330, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1913, 330, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1914, 330, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1915, 330, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1916, 330, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1917, 330, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1918, 330, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1919, 330, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1920, 331, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1921, 331, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1922, 331, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1923, 331, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1924, 331, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1925, 331, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1926, 331, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1927, 331, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(1928, 331, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(1929, 332, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1930, 332, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1931, 332, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1932, 332, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1933, 332, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1934, 332, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1935, 332, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1936, 332, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1937, 332, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1938, 333, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1939, 333, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1940, 333, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(1941, 333, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1942, 333, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(1943, 334, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1944, 334, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1945, 334, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(1946, 334, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(1947, 334, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(1948, 335, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1949, 335, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1950, 335, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1951, 335, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(1952, 335, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(1953, 336, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1954, 336, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1955, 336, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1956, 336, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1957, 336, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(1958, 336, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1959, 336, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1960, 336, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1961, 336, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1962, 337, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1963, 337, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1964, 337, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1965, 337, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1966, 337, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1967, 337, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1968, 337, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1969, 337, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1970, 337, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1971, 338, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1972, 338, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1973, 338, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1974, 338, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1975, 338, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(1976, 338, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1977, 338, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1978, 338, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1979, 338, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(1980, 339, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1981, 339, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1982, 339, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1983, 339, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1984, 339, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1985, 339, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1986, 339, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1987, 339, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1988, 339, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1989, 340, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1990, 340, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1991, 340, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1992, 340, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1993, 340, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(1994, 340, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1995, 340, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(1996, 340, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(1997, 340, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(1998, 341, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(1999, 341, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2000, 341, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2001, 341, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2002, 341, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2004, 341, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2005, 341, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2006, 341, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2007, 342, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2008, 342, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2009, 342, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2010, 342, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2011, 342, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2012, 342, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2013, 342, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2014, 342, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2015, 343, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2016, 343, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2017, 343, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2018, 343, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2019, 343, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2020, 343, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2021, 343, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2022, 343, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2023, 344, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2024, 344, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2025, 344, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2026, 344, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2027, 344, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2028, 344, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2029, 344, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2030, 344, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2031, 344, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2032, 344, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2033, 345, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2034, 345, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2035, 345, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2036, 345, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2037, 345, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2038, 345, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2039, 345, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2040, 345, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2041, 345, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2042, 345, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2043, 346, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2044, 346, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2045, 346, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2046, 346, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2047, 346, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2048, 346, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2049, 346, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2050, 346, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2051, 346, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2052, 346, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2053, 347, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2054, 347, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2055, 347, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2056, 347, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2057, 347, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2058, 347, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2059, 347, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2060, 347, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2061, 347, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2062, 347, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2063, 348, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2064, 348, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2065, 348, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2066, 348, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2067, 348, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2068, 348, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2069, 348, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2070, 348, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2071, 348, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2072, 348, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2073, 349, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2074, 349, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2075, 349, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2076, 349, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2077, 349, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2078, 349, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2079, 349, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2080, 349, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2081, 349, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2082, 349, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2083, 350, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2084, 350, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2085, 350, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2086, 350, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2087, 350, 4, 'A5', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2088, 351, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2089, 351, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2090, 351, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2091, 351, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2092, 351, 4, 'A5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2093, 352, 0, 'A1', -10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2094, 352, 1, 'A2', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2095, 352, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2096, 352, 3, 'A4', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2097, 352, 4, 'A5', 10287, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2098, 353, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2099, 353, 1, 'A2', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2100, 353, 2, 'A3', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2101, 353, 3, 'A4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2102, 353, 4, 'A5', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2103, 353, 5, 'A6', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2104, 353, 6, 'A7', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2105, 354, 0, 'A1', -9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2106, 354, 1, 'A2', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2107, 354, 2, 'A3', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2108, 354, 3, 'A4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2109, 354, 4, 'A5', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2110, 354, 5, 'A6', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2111, 354, 6, 'A7', 9906, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2112, 355, 0, 'A1', -11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2113, 355, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2114, 355, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2115, 355, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2116, 355, 4, 'A5', 11621, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2117, 356, 0, 'A1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2118, 356, 1, 'A2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2119, 356, 2, 'A3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2120, 356, 3, 'A4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2121, 356, 4, 'A5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2122, 357, 0, 'A1', -11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2123, 357, 1, 'A2', -6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2124, 357, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2125, 357, 3, 'A4', 6477, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2126, 357, 4, 'A5', 11811, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2127, 358, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2128, 358, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2129, 358, 2, 'A3', -7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2130, 358, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2131, 358, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2132, 358, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2133, 358, 6, 'A7', 7430, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2134, 358, 7, 'A8', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2135, 358, 8, 'A9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2136, 359, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2137, 359, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2138, 359, 2, 'A3', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2139, 359, 3, 'A4', -3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2140, 359, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2141, 359, 5, 'A6', 3566, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2142, 359, 6, 'A7', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2143, 359, 7, 'A8', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2144, 359, 8, 'A9', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2145, 360, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2146, 360, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2147, 360, 2, 'A3', -7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2148, 360, 3, 'A4', -3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2149, 360, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2150, 360, 5, 'A6', 3810, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2151, 360, 6, 'A7', 7620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2152, 360, 7, 'A8', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2153, 360, 8, 'A9', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2154, 361, 0, 'A1', -12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2155, 361, 1, 'A2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2156, 361, 2, 'A3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2157, 361, 3, 'A4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2158, 361, 4, 'A5', 12383, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2159, 362, 0, 'A1', -12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2160, 362, 1, 'A2', -6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2161, 362, 2, 'A3', 0, 0, 7112, 0);
INSERT INTO MP_EquipmentSection VALUES(2162, 362, 3, 'A4', 6858, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2163, 362, 4, 'A5', 12954, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2164, 363, 0, 'A1', -12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2165, 363, 1, 'A2', -6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2166, 363, 2, 'A3', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2167, 363, 3, 'A4', 6096, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2168, 363, 4, 'A5', 12192, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2169, 364, 0, 'A1', -13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2170, 364, 1, 'A2', -10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2171, 364, 2, 'A3', -7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2172, 364, 3, 'A4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2173, 364, 4, 'A5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2174, 364, 5, 'A6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2175, 364, 6, 'A7', 7049, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2176, 364, 7, 'A8', 10097, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2177, 364, 8, 'A9', 13526, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2178, 365, 0, 'A1', -13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2179, 365, 1, 'A2', -10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2180, 365, 2, 'A3', -6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2181, 365, 3, 'A4', -3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2182, 365, 4, 'A5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2183, 365, 5, 'A6', 3302, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2184, 365, 6, 'A7', 6858, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2185, 365, 7, 'A8', 10414, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2186, 365, 8, 'A9', 13970, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2187, 366, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2188, 366, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2189, 366, 2, 'A3', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2190, 366, 3, 'A4', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2191, 366, 4, 'A5', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2192, 366, 5, 'A6', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2193, 366, 6, 'A7', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2194, 366, 7, 'A8', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2195, 366, 8, 'A9', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2196, 367, 0, 'A1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2197, 367, 1, 'A2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2198, 367, 2, 'A3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2199, 367, 3, 'A4', -4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2200, 367, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2201, 367, 5, 'A6', 4064, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2202, 367, 6, 'A7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2203, 367, 7, 'A8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2204, 367, 8, 'A9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2205, 368, 0, 'A1', -18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2206, 368, 1, 'A2', -13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2207, 368, 2, 'A3', -8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2208, 368, 3, 'A4', -4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2209, 368, 4, 'A5', 0, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2210, 368, 5, 'A6', 4572, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2211, 368, 6, 'A7', 8890, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2212, 368, 7, 'A8', 13208, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2213, 368, 8, 'A9', 18034, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2214, 369, 0, 'A1', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2215, 369, 1, 'A2', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2216, 369, 2, 'A3', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2217, 369, 3, 'A4', -1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2218, 369, 4, 'A5', 1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2220, 369, 5, 'A6', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2221, 369, 6, 'A7', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2222, 369, 7, 'A8', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2223, 370, 0, 'A1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2224, 370, 1, 'A2', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2225, 370, 2, 'A3', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2226, 370, 3, 'A4', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2227, 370, 4, 'A5', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2228, 370, 5, 'A6', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2229, 370, 6, 'A7', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2230, 370, 7, 'A8', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2231, 371, 0, 'A1', -11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2232, 371, 1, 'A2', -9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2233, 371, 2, 'A3', -5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2234, 371, 3, 'A4', -1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2235, 371, 4, 'A5', 1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2236, 371, 5, 'A6', 5715, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2237, 371, 6, 'A7', 9144, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2238, 371, 7, 'A8', 11430, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2239, 372, 0, 'A1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2240, 372, 1, 'A2', -10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2241, 372, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2242, 372, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2243, 372, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2244, 372, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2245, 372, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2246, 372, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2247, 372, 8, 'A9', 10478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2248, 372, 9, 'A10', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2249, 373, 0, 'A1', -12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2250, 373, 1, 'A2', -10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2251, 373, 2, 'A3', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2252, 373, 3, 'A4', -4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2253, 373, 4, 'A5', -1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2254, 373, 5, 'A6', 1524, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2255, 373, 6, 'A7', 4572, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2256, 373, 7, 'A8', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2257, 373, 8, 'A9', 10414, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2258, 373, 9, 'A10', 12700, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(2259, 374, 0, 'A1', -12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2260, 374, 1, 'A2', -10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2261, 374, 2, 'A3', -8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2262, 374, 3, 'A4', -4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2263, 374, 4, 'A5', -1905, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2264, 374, 5, 'A6', 1524, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2265, 374, 6, 'A7', 4953, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2266, 374, 7, 'A8', 8001, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2267, 374, 8, 'A9', 10668, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2268, 374, 9, 'A10', 12954, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2269, 375, 0, 'A1', -13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2270, 375, 1, 'A2', -10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2271, 375, 2, 'A3', -7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2272, 375, 3, 'A4', -4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2273, 375, 4, 'A5', -1524, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2274, 375, 5, 'A6', 1715, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2275, 375, 6, 'A7', 4763, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2276, 375, 7, 'A8', 7811, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2277, 375, 8, 'A9', 10859, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2278, 375, 9, 'A10', 13907, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2279, 376, 0, 'A1', -14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2280, 376, 1, 'A2', -11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2281, 376, 2, 'A3', -8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2282, 376, 3, 'A4', -5080, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2283, 376, 4, 'A5', -1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2284, 376, 5, 'A6', 1778, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2285, 376, 6, 'A7', 5080, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2286, 376, 7, 'A8', 8128, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2287, 376, 8, 'A9', 11430, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2288, 376, 9, 'A10', 14478, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(2289, 377, 0, 'A1', -14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2290, 377, 1, 'A2', -12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2291, 377, 2, 'A3', -9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2292, 377, 3, 'A4', -6858, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2293, 377, 4, 'A5', -2667, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2294, 377, 5, 'A6', 1905, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2295, 377, 6, 'A7', 6477, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2296, 377, 7, 'A8', 9906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2297, 377, 8, 'A9', 12192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2298, 377, 9, 'A10', 14478, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2299, 378, 0, '1', -4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2300, 378, 1, '2', 4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2301, 379, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2302, 379, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2303, 380, 1, '1', -7239, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2304, 380, 2, '2', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2305, 380, 3, '3', 7239, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2306, 381, 1, '1', -7620, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2307, 381, 2, '2', 0, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2308, 381, 3, '3', 7620, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2309, 382, 1, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2310, 382, 2, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2311, 382, 3, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2312, 382, 4, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2313, 382, 5, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2314, 383, 1, '1', -9144, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2315, 383, 2, '2', -4572, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2316, 383, 3, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2317, 383, 4, '4', 4572, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2318, 383, 5, '5', 9144, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2319, 384, 1, '1', -10668, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2320, 384, 2, '2', -5334, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2321, 384, 3, '3', 0, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2322, 384, 4, '4', 5334, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2323, 384, 5, '5', 10668, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2324, 385, 1, '1', -10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2325, 385, 2, '2', -5334, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2326, 385, 3, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2327, 385, 4, '4', 5334, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2328, 385, 5, '5', 10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2329, 386, 1, '1', -7239, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2330, 386, 2, '2', 0, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2331, 386, 3, '3', 7239, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2332, 387, 1, '1', -7620, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2333, 387, 2, '2', 0, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2334, 387, 3, '3', 7620, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2335, 388, 1, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2336, 388, 2, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2337, 388, 3, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2338, 388, 4, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2339, 388, 5, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2340, 389, 1, '1', -9144, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2341, 389, 2, '2', -4572, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2342, 389, 3, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2343, 389, 4, '4', 4572, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2344, 389, 5, '5', 9144, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2345, 390, 1, '1', -10668, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2346, 390, 2, '2', -5334, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2347, 390, 3, '3', 0, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2348, 390, 4, '4', 5334, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2349, 390, 5, '5', 10668, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2350, 391, 1, '1', -10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2351, 391, 2, '2', -5334, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2352, 391, 3, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2353, 391, 4, '4', 5334, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2354, 391, 5, '5', 10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2355, 392, 0, '1', -4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2356, 392, 1, '2', 4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2357, 393, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2358, 393, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2359, 394, 0, '1', -10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2360, 394, 1, '2', -6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2361, 394, 2, '3', 0, 0, 7366, 0);
INSERT INTO MP_EquipmentSection VALUES(2362, 394, 3, '4', 6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2363, 394, 4, '5', 10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2364, 395, 0, '1', -10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2365, 395, 1, '2', -7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2366, 395, 2, '3', -3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2367, 395, 3, '4', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2368, 395, 4, '5', 3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2369, 395, 5, '6', 7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2370, 395, 6, '7', 10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2383, 402, 0, '1', -10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2384, 402, 1, '2', -6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2385, 402, 2, '3', 0, 0, 7239, 0);
INSERT INTO MP_EquipmentSection VALUES(2386, 402, 3, '4', 6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2387, 402, 4, '5', 10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2388, 403, 0, '1', -10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2389, 403, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2390, 403, 2, '3', -3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2391, 403, 3, '4', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2392, 403, 4, '5', 3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2393, 403, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2394, 403, 6, '7', 10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2395, 404, 0, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2396, 404, 1, '2', -6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2397, 404, 2, '3', 0, 0, 8128, 0);
INSERT INTO MP_EquipmentSection VALUES(2398, 404, 3, '4', 6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2399, 404, 4, '5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2400, 405, 0, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2401, 405, 1, '2', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2402, 405, 2, '3', -3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2403, 405, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2404, 405, 4, '5', 3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2405, 405, 5, '6', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2406, 405, 6, '7', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2407, 406, 0, '1', -10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(2408, 406, 1, '2', -6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(2409, 406, 2, '3', 0, 0, 8000, 0);
INSERT INTO MP_EquipmentSection VALUES(2410, 406, 3, '4', 6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(2411, 406, 4, '5', 10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(2412, 407, 0, '1', -10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(2413, 407, 1, '2', -7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2414, 407, 2, '3', -3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2415, 407, 3, '4', 0, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2416, 407, 4, '5', 3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2417, 407, 5, '6', 7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2418, 407, 6, '7', 10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(2419, 408, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2420, 408, 1, '2', -6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2421, 408, 2, '3', 0, 0, 7366, 0);
INSERT INTO MP_EquipmentSection VALUES(2422, 408, 3, '4', 6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2423, 408, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2424, 409, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2425, 409, 1, '2', -7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2426, 409, 2, '3', -3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2427, 409, 3, '4', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2428, 409, 4, '5', 3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2429, 409, 5, '6', 7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2430, 409, 6, '7', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2431, 410, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2432, 410, 1, '2', -6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2433, 410, 2, '3', 0, 0, 7239, 0);
INSERT INTO MP_EquipmentSection VALUES(2434, 410, 3, '4', 6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2435, 410, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2436, 411, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2437, 411, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2438, 411, 2, '3', -3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2439, 411, 3, '4', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2440, 411, 4, '5', 3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2441, 411, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2442, 411, 6, '7', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2443, 412, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2444, 412, 1, '2', -6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2445, 412, 2, '3', 0, 0, 8128, 0);
INSERT INTO MP_EquipmentSection VALUES(2446, 412, 3, '4', 6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(2447, 412, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2448, 413, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2449, 413, 1, '2', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2450, 413, 2, '3', -3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2451, 413, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2452, 413, 4, '5', 3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2453, 413, 5, '6', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(2454, 413, 6, '7', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2455, 414, 0, '1', -11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2456, 414, 1, '2', -6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(2457, 414, 2, '3', 0, 0, 8000, 0);
INSERT INTO MP_EquipmentSection VALUES(2458, 414, 3, '4', 6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(2459, 414, 4, '5', 11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2460, 415, 0, '1', -11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2461, 415, 1, '2', -7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2462, 415, 2, '3', -3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2463, 415, 3, '4', 0, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2464, 415, 4, '5', 3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2465, 415, 5, '6', 7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2466, 415, 6, '7', 11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(2467, 416, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2468, 416, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2469, 416, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2470, 416, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2471, 416, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2472, 417, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2473, 417, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2474, 417, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2475, 417, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2476, 417, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2477, 418, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2478, 418, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2479, 418, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2480, 418, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2481, 418, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2482, 419, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2483, 419, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2484, 419, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2485, 419, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2486, 419, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2487, 420, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2488, 420, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2489, 420, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2490, 420, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2491, 420, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2492, 421, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2493, 421, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2494, 421, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2495, 421, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2496, 421, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2497, 422, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2498, 422, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2499, 422, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2500, 422, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2501, 422, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2502, 423, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2503, 423, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2504, 423, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2505, 423, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2506, 423, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2507, 424, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2508, 424, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2509, 424, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2510, 424, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2511, 424, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2512, 424, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2513, 424, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2514, 425, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2515, 425, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2516, 425, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2517, 425, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2518, 425, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2519, 425, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2520, 425, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2521, 426, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2522, 426, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2523, 426, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2524, 426, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2525, 426, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2526, 426, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2527, 426, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2528, 427, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2529, 427, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2530, 427, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2531, 427, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2532, 427, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2533, 427, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2534, 427, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2553, 433, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2554, 433, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2555, 434, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2556, 434, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2557, 435, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2558, 436, 0, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2559, 436, 1, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2560, 436, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2561, 436, 3, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2562, 436, 4, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2563, 437, 0, '1', -11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2564, 437, 1, '2', -6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2565, 437, 2, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2566, 437, 3, '4', 6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2567, 437, 4, '5', 11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2568, 438, 0, '1', -9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2569, 438, 1, '2', -4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2570, 438, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2571, 438, 3, '4', 4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2572, 438, 4, '5', 9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2573, 441, 0, '1', -4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2574, 441, 1, '2', 4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2575, 442, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2576, 443, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2577, 443, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2578, 443, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2579, 443, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2580, 443, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2581, 444, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2582, 444, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2583, 444, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2584, 444, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2585, 444, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2586, 445, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2587, 445, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2588, 445, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2589, 445, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2590, 445, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2591, 446, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2592, 446, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2593, 446, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2594, 446, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2595, 446, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2596, 447, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2597, 447, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2598, 447, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2599, 447, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2600, 447, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2601, 448, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2602, 448, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2603, 448, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2604, 448, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2605, 448, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2606, 449, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2607, 449, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2608, 449, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2609, 449, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2610, 449, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2611, 450, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2612, 450, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2613, 450, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2614, 450, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2615, 450, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2616, 451, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2617, 451, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2618, 451, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2619, 451, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2620, 451, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2621, 451, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2622, 451, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2623, 452, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2624, 452, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2625, 452, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2626, 452, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2627, 452, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2628, 452, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2629, 452, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2630, 453, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2631, 453, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2632, 453, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2633, 453, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2634, 453, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2635, 453, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2636, 453, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2637, 454, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2638, 454, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2639, 454, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2640, 454, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2641, 454, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2642, 454, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2643, 454, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2644, 455, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2645, 455, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2646, 455, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2647, 455, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2648, 455, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2649, 456, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2650, 456, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2651, 456, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2652, 456, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2653, 456, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2654, 457, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2655, 457, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2656, 457, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2657, 457, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2658, 457, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2659, 458, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2660, 458, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2661, 458, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2662, 458, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2663, 458, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2664, 459, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2665, 459, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2666, 459, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2667, 459, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2668, 459, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(2669, 460, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2670, 460, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2671, 460, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2672, 460, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2673, 460, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(2674, 461, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2675, 461, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2676, 461, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2677, 461, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2678, 461, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2679, 462, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2680, 462, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2681, 462, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2682, 462, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2683, 462, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(2684, 463, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2685, 463, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2686, 463, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2687, 463, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(2688, 463, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2689, 463, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2690, 463, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2691, 464, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2692, 464, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2693, 464, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2694, 464, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2695, 464, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(2696, 464, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2697, 464, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2698, 465, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2699, 465, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2700, 465, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2701, 465, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2702, 465, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(2703, 465, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2704, 465, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2705, 466, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2706, 466, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2707, 466, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2708, 466, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(2709, 466, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(2710, 466, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(2711, 466, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(2712, 467, 0, '1', -4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2713, 467, 1, '2', 4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2714, 468, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2715, 469, 0, '1', -4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2716, 469, 1, '2', 4572, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2717, 470, 0, 'BLT', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2718, 471, 0, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2719, 471, 1, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2720, 471, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2721, 471, 3, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2722, 471, 4, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2723, 472, 0, '1', -11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2724, 472, 1, '2', -6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2725, 472, 2, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2726, 472, 3, '4', 6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2727, 472, 4, '5', 11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2728, 473, 0, '1', -9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2729, 473, 1, '2', -4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2730, 473, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2731, 473, 3, '4', 4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2732, 473, 4, '5', 9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2733, 474, 0, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2734, 474, 1, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2735, 474, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2736, 474, 3, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2737, 474, 4, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2738, 475, 0, '1', -11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2739, 475, 1, '2', -6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2740, 475, 2, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2741, 475, 3, '4', 6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2742, 475, 4, '5', 11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2743, 476, 0, '1', -9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2744, 476, 1, '2', -4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2745, 476, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2746, 476, 3, '4', 4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2747, 476, 4, '5', 9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2748, 477, 0, '1', -8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2749, 477, 1, '2', -4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2750, 477, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2751, 477, 3, '4', 4191, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2752, 477, 4, '5', 8763, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2753, 478, 0, '1', -11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2754, 478, 1, '2', -6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2755, 478, 2, '3', 0, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2756, 478, 3, '4', 6096, 0, 7620, 0);
INSERT INTO MP_EquipmentSection VALUES(2757, 478, 4, '5', 11430, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2758, 479, 0, '1', -9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2759, 479, 1, '2', -4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2760, 479, 2, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2761, 479, 3, '4', 4572, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2762, 479, 4, '5', 9906, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2763, 480, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2764, 480, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2765, 481, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2766, 481, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2767, 482, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2768, 483, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2769, 483, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2770, 484, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2771, 484, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2772, 485, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2773, 486, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2774, 486, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2775, 487, 0, '1', -5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2776, 487, 1, '2', 5334, 0, 10668, 0);
INSERT INTO MP_EquipmentSection VALUES(2777, 488, 0, 'BLT', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(2778, 489, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2779, 489, 1, '1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2780, 489, 2, '2', -10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2781, 489, 3, '3', -7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2782, 489, 4, '4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2783, 489, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2784, 489, 6, '6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2785, 489, 7, '7', 7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2786, 489, 8, '8', 10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2787, 489, 9, '9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2788, 490, 0, 'L', -14110, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2789, 490, 1, '1', -11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2790, 490, 3, '2', -5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2791, 490, 5, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2792, 490, 7, '4', 5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2793, 490, 9, '5', 11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2794, 491, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2795, 491, 1, '1', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2796, 491, 2, '2', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2797, 491, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2798, 491, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2799, 491, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2800, 491, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2801, 491, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2802, 491, 8, '8', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2803, 491, 9, '9', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2804, 492, 0, 'L', -15443, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2805, 492, 1, '1', -14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2806, 492, 2, '2', -12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2807, 492, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2808, 492, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2809, 492, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2810, 492, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2811, 492, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2812, 492, 8, '8', 12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2813, 492, 9, '9', 14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2814, 493, 0, 'L', -18301, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2815, 493, 1, '1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2816, 493, 2, '2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2817, 493, 3, '3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2818, 493, 4, '4', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2819, 493, 5, '5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2820, 493, 6, '6', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2821, 493, 7, '7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2822, 493, 8, '8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2823, 493, 9, '9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2824, 494, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2825, 495, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2826, 496, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2827, 496, 1, '1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2828, 496, 2, '2', -10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2829, 496, 3, '3', -7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2830, 496, 4, '4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2831, 496, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2832, 496, 6, '6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2833, 496, 7, '7', 7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2834, 496, 8, '8', 10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2835, 496, 9, '9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2836, 497, 0, 'L', -14110, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2837, 497, 1, '1', -11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2838, 497, 3, '2', -5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2839, 497, 5, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2840, 497, 7, '4', 5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2841, 497, 9, '5', 11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2842, 498, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2843, 498, 1, '1', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2844, 498, 2, '2', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2845, 498, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2846, 498, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2847, 498, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2848, 498, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2849, 498, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2850, 498, 8, '8', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2851, 498, 9, '9', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2852, 499, 0, 'L', -15443, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2853, 499, 1, '1', -14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2854, 499, 2, '2', -12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2855, 499, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2856, 499, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2857, 499, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2858, 499, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2859, 499, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2860, 499, 8, '8', 12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2861, 499, 9, '9', 14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2862, 500, 0, 'L', -18301, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2863, 500, 1, '1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2864, 500, 2, '2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2865, 500, 3, '3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2866, 500, 4, '4', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2867, 500, 5, '5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2868, 500, 6, '6', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2869, 500, 7, '7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2870, 500, 8, '8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2871, 500, 9, '9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2872, 501, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2873, 501, 1, '1', -12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2874, 501, 2, '2', -10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2875, 501, 3, '3', -7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2876, 501, 4, '4', -3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2877, 501, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2878, 501, 6, '6', 3620, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2879, 501, 7, '7', 7239, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2880, 501, 8, '8', 10287, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2881, 501, 9, '9', 12764, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2882, 502, 0, 'L', -14110, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2883, 502, 1, '1', -11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2884, 502, 3, '2', -5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2885, 502, 5, '3', 0, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2886, 502, 7, '4', 5334, 0, 6858, 0);
INSERT INTO MP_EquipmentSection VALUES(2887, 502, 9, '5', 11430, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(2888, 503, 0, 'L', -13919, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2889, 503, 1, '1', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2890, 503, 2, '2', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2891, 503, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2892, 503, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2893, 503, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2894, 503, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2895, 503, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2896, 503, 8, '8', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2897, 503, 9, '9', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(2898, 504, 0, 'L', -15443, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2899, 504, 1, '1', -14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2900, 504, 2, '2', -12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2901, 504, 3, '3', -8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2902, 504, 4, '4', -4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2903, 504, 5, '5', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(2904, 504, 6, '6', 4001, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2905, 504, 7, '7', 8573, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2906, 504, 8, '8', 12002, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2907, 504, 9, '9', 14288, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(2908, 505, 0, 'L', -18301, 0, 25, 1);
INSERT INTO MP_EquipmentSection VALUES(2909, 505, 1, '1', -16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2910, 505, 2, '2', -12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2911, 505, 3, '3', -8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2912, 505, 4, '4', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2913, 505, 5, '5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2914, 505, 6, '6', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2915, 505, 7, '7', 8128, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2916, 505, 8, '8', 12192, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2917, 505, 9, '9', 16256, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2918, 506, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2919, 507, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2920, 508, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2921, 509, 1, '1', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(2922, 510, 0, '1', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2923, 510, 1, '2', -10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2924, 510, 2, '3', -4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2925, 510, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2926, 510, 4, '5', 4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2927, 510, 5, '6', 10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2928, 510, 6, '7', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2929, 511, 0, '1', -17145, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2930, 511, 1, '2', -12192, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2931, 511, 2, '3', -4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2932, 511, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2933, 511, 4, '5', 4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2934, 511, 5, '6', 12192, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2935, 511, 6, '7', 17145, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2936, 512, 0, '1', -18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2937, 512, 1, '2', -15240, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2938, 512, 2, '3', -9144, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2939, 512, 3, '4', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2940, 512, 4, '5', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2941, 512, 5, '6', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(2942, 512, 6, '7', 9144, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2943, 512, 7, '8', 15240, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2944, 512, 8, '9', 18669, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2945, 513, 0, '1', -17145, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2946, 513, 1, '2', -12192, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2947, 513, 2, '3', -4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2948, 513, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2949, 513, 4, '5', 4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2950, 513, 5, '6', 12192, 0, 9144, 0);
INSERT INTO MP_EquipmentSection VALUES(2951, 513, 6, '7', 17145, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2952, 514, 0, '1', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2953, 514, 1, '2', -10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2954, 514, 2, '3', -4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2955, 514, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(2956, 514, 4, '5', 4572, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2957, 514, 5, '6', 10668, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(2958, 514, 6, '7', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(2959, 515, 8, 'L', -12192, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2960, 515, 0, '1', -10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2961, 515, 1, '2', -6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2962, 515, 2, '3', 0, 0, 7366, 0);
INSERT INTO MP_EquipmentSection VALUES(2963, 515, 3, '4', 6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2964, 515, 4, '5', 10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2965, 515, 9, 'R', 12192, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2966, 516, 8, 'L', -12192, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2967, 516, 0, '1', -10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2968, 516, 1, '2', -7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2969, 516, 2, '3', -3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2970, 516, 3, '4', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2971, 516, 4, '5', 3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2972, 516, 5, '6', 7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2973, 516, 6, '7', 10668, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2974, 516, 9, 'R', 12192, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2975, 517, 8, 'L', -13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2976, 517, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2977, 517, 1, '2', -6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2978, 517, 2, '3', 0, 0, 7366, 0);
INSERT INTO MP_EquipmentSection VALUES(2979, 517, 3, '4', 6477, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(2980, 517, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2981, 517, 9, 'R', 13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2982, 518, 8, 'L', -13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2983, 518, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2984, 518, 1, '2', -7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2985, 518, 2, '3', -3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2986, 518, 3, '4', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(2987, 518, 4, '5', 3302, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(2988, 518, 5, '6', 7239, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(2989, 518, 6, '7', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(2990, 518, 9, 'R', 13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(2991, 519, 8, 'L', -12192, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(2992, 519, 0, '1', -10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2993, 519, 1, '2', -6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2994, 519, 2, '3', 0, 0, 7239, 0);
INSERT INTO MP_EquipmentSection VALUES(2995, 519, 3, '4', 6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(2996, 519, 4, '5', 10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(2997, 519, 9, 'R', 12192, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(2998, 520, 8, 'L', -12192, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(2999, 520, 0, '1', -10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3000, 520, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3001, 520, 2, '3', -3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3002, 520, 3, '4', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3003, 520, 4, '5', 3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3004, 520, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3005, 520, 6, '7', 10668, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3006, 520, 9, 'R', 12192, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3007, 521, 8, 'L', -13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3008, 521, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3009, 521, 1, '2', -6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3010, 521, 2, '3', 0, 0, 7239, 0);
INSERT INTO MP_EquipmentSection VALUES(3011, 521, 3, '4', 6477, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3012, 521, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3013, 521, 9, 'R', 13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3014, 522, 8, 'L', -13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3015, 522, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3016, 522, 1, '2', -7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3017, 522, 2, '3', -3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3018, 522, 3, '4', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3019, 522, 4, '5', 3239, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3020, 522, 5, '6', 7239, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3021, 522, 6, '7', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3022, 522, 9, 'R', 13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3023, 523, 8, 'L', -12446, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3024, 523, 0, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3025, 523, 1, '2', -6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(3026, 523, 2, '3', 0, 0, 8128, 0);
INSERT INTO MP_EquipmentSection VALUES(3027, 523, 3, '4', 6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(3028, 523, 4, '5', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3029, 523, 9, 'R', 12446, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3030, 524, 8, 'L', -12446, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3031, 524, 0, '1', -10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3032, 524, 1, '2', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(3033, 524, 2, '3', -3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(3034, 524, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3035, 524, 4, '5', 3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(3036, 524, 5, '6', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(3037, 524, 6, '7', 10668, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3038, 524, 9, 'R', 12446, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3039, 525, 8, 'L', -13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3040, 525, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3041, 525, 1, '2', -6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(3042, 525, 2, '3', 0, 0, 8128, 0);
INSERT INTO MP_EquipmentSection VALUES(3043, 525, 3, '4', 6604, 0, 5080, 0);
INSERT INTO MP_EquipmentSection VALUES(3044, 525, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3045, 525, 9, 'R', 13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3046, 526, 8, 'L', -13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3047, 526, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3048, 526, 1, '2', -7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(3049, 526, 2, '3', -3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(3050, 526, 3, '4', 0, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3051, 526, 4, '5', 3556, 0, 4064, 0);
INSERT INTO MP_EquipmentSection VALUES(3052, 526, 5, '6', 7366, 0, 3556, 0);
INSERT INTO MP_EquipmentSection VALUES(3053, 526, 6, '7', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3054, 526, 9, 'R', 13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3055, 527, 8, 'L', -12250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3056, 527, 0, '1', -10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(3057, 527, 1, '2', -6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(3058, 527, 2, '3', 0, 0, 8000, 0);
INSERT INTO MP_EquipmentSection VALUES(3059, 527, 3, '4', 6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(3060, 527, 4, '5', 10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(3061, 527, 9, 'R', 12250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3062, 528, 8, 'L', -12250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3063, 528, 0, '1', -10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(3064, 528, 1, '2', -7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3065, 528, 2, '3', -3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3066, 528, 3, '4', 0, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3067, 528, 4, '5', 3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3068, 528, 5, '6', 7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3069, 528, 6, '7', 10750, 0, 2500, 0);
INSERT INTO MP_EquipmentSection VALUES(3070, 528, 9, 'R', 12250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3071, 529, 8, 'L', -13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3072, 529, 0, '1', -11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3073, 529, 1, '2', -6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(3074, 529, 2, '3', 0, 0, 8000, 0);
INSERT INTO MP_EquipmentSection VALUES(3075, 529, 3, '4', 6750, 0, 5500, 0);
INSERT INTO MP_EquipmentSection VALUES(3076, 529, 4, '5', 11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3077, 529, 9, 'R', 13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3078, 530, 8, 'L', -13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3079, 530, 0, '1', -11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3080, 530, 1, '2', -7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3081, 530, 2, '3', -3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3082, 530, 3, '4', 0, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3083, 530, 4, '5', 3500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3084, 530, 5, '6', 7500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3085, 530, 6, '7', 11500, 0, 4000, 0);
INSERT INTO MP_EquipmentSection VALUES(3086, 530, 9, 'R', 13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3087, 531, 8, 'L', -13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3088, 531, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3089, 531, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3090, 531, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3091, 531, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3092, 531, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3093, 531, 9, 'R', 13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3094, 533, 8, 'L', -13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3095, 533, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3096, 533, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3097, 533, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3098, 533, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3099, 533, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3100, 533, 9, 'R', 13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3101, 534, 8, 'L', -13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3102, 534, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3103, 534, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3104, 534, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3105, 534, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3106, 534, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3107, 534, 9, 'R', 13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3108, 535, 8, 'L', -13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3109, 535, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3110, 535, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3111, 535, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3112, 535, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3113, 535, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3114, 535, 9, 'R', 13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3115, 536, 8, 'L', -15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3116, 536, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3117, 536, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3118, 536, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3119, 536, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3120, 536, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3121, 536, 9, 'R', 15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3122, 537, 8, 'L', -15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3123, 537, 0, '1', -12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3124, 537, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3125, 537, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3126, 537, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3127, 537, 4, '5', 12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3128, 537, 9, 'R', 15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3129, 538, 8, 'L', -15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3130, 538, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3131, 538, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3132, 538, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3133, 538, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3134, 538, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3135, 538, 9, 'R', 15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3136, 539, 8, 'L', -15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3137, 539, 0, '1', -12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3138, 539, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3139, 539, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3140, 539, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3141, 539, 4, '5', 12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3142, 539, 9, 'R', 15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3143, 540, 8, 'L', -18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3144, 540, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3145, 540, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3146, 540, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3147, 540, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3148, 540, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3149, 540, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3150, 540, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3151, 540, 9, 'R', 18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3152, 541, 8, 'L', -18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3153, 541, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3154, 541, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3155, 541, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3156, 541, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3157, 541, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3158, 541, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3159, 541, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3160, 541, 9, 'R', 18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3161, 542, 8, 'L', -18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3162, 542, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3163, 542, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3164, 542, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3165, 542, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3166, 542, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3167, 542, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3168, 542, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3169, 542, 9, 'R', 18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3170, 543, 8, 'L', -18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3171, 543, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3172, 543, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3173, 543, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3174, 543, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3175, 543, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3176, 543, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3177, 543, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3178, 543, 9, 'R', 18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3179, 544, 8, 'L', -13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3180, 544, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3181, 544, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3182, 544, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3183, 544, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3184, 544, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3185, 544, 9, 'R', 13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3186, 545, 8, 'L', -13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3187, 545, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3188, 545, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3189, 545, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3190, 545, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3191, 545, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3192, 545, 9, 'R', 13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3193, 546, 8, 'L', -13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3194, 546, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3195, 546, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3196, 546, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3197, 546, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3198, 546, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3199, 546, 9, 'R', 13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3200, 547, 8, 'L', -13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3201, 547, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3202, 547, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3203, 547, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3204, 547, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3205, 547, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3206, 547, 9, 'R', 13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3207, 548, 8, 'L', -15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3208, 548, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3209, 548, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3210, 548, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3211, 548, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3212, 548, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3213, 548, 9, 'R', 15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3214, 549, 8, 'L', -15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3215, 549, 0, '1', -12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3216, 549, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3217, 549, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3218, 549, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3219, 549, 4, '5', 12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3220, 549, 9, 'R', 15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3221, 550, 8, 'L', -15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3222, 550, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3223, 550, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3224, 550, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3225, 550, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3226, 550, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3227, 550, 9, 'R', 15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3228, 551, 8, 'L', -15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3229, 551, 0, '1', -12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3230, 551, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3231, 551, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3232, 551, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3233, 551, 4, '5', 12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3234, 551, 9, 'R', 15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3235, 552, 8, 'L', -18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3236, 552, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3237, 552, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3238, 552, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3239, 552, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3240, 552, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3241, 552, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3242, 552, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3243, 552, 9, 'R', 18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3244, 553, 8, 'L', -18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3245, 553, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3246, 553, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3247, 553, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3248, 553, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3249, 553, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3250, 553, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3251, 553, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3252, 553, 9, 'R', 18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3253, 554, 8, 'L', -18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3254, 554, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3255, 554, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3256, 554, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3257, 554, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3258, 554, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3259, 554, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3260, 554, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3261, 554, 9, 'R', 18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3262, 555, 8, 'L', -18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3263, 555, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3264, 555, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3265, 555, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3266, 555, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3267, 555, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3268, 555, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3269, 555, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3270, 555, 9, 'R', 18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3271, 556, 8, 'L', -13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3272, 556, 0, '1', -11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3273, 556, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3274, 556, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3275, 556, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3276, 556, 4, '5', 11430, 0, 4318, 0);
INSERT INTO MP_EquipmentSection VALUES(3277, 556, 9, 'R', 13716, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3278, 557, 8, 'L', -13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3279, 557, 0, '1', -11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3280, 557, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3281, 557, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3282, 557, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3283, 557, 4, '5', 11430, 0, 4191, 0);
INSERT INTO MP_EquipmentSection VALUES(3284, 557, 9, 'R', 13716, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3285, 558, 8, 'L', -13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3286, 558, 0, '1', -11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3287, 558, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3288, 558, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3289, 558, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3290, 558, 4, '5', 11430, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(3291, 558, 9, 'R', 13970, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3292, 559, 8, 'L', -13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3293, 559, 0, '1', -11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3294, 559, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3295, 559, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3296, 559, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3297, 559, 4, '5', 11250, 0, 4500, 0);
INSERT INTO MP_EquipmentSection VALUES(3298, 559, 9, 'R', 13750, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3299, 560, 8, 'L', -15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3300, 560, 0, '1', -12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3301, 560, 1, '2', -6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3302, 560, 2, '3', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3303, 560, 3, '4', 6223, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3304, 560, 4, '5', 12192, 0, 5842, 0);
INSERT INTO MP_EquipmentSection VALUES(3305, 560, 9, 'R', 15240, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3306, 561, 8, 'L', -15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3307, 561, 0, '1', -12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3308, 561, 1, '2', -6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3309, 561, 2, '3', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3310, 561, 3, '4', 6287, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3311, 561, 4, '5', 12192, 0, 5715, 0);
INSERT INTO MP_EquipmentSection VALUES(3312, 561, 9, 'R', 15240, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3313, 562, 8, 'L', -15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3314, 562, 0, '1', -12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3315, 562, 1, '2', -6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3316, 562, 2, '3', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3317, 562, 3, '4', 6096, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3318, 562, 4, '5', 12192, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3319, 562, 9, 'R', 15494, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3320, 563, 8, 'L', -15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3321, 563, 0, '1', -12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3322, 563, 1, '2', -6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3323, 563, 2, '3', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3324, 563, 3, '4', 6000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3325, 563, 4, '5', 12000, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3326, 563, 9, 'R', 15250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3327, 564, 8, 'L', -18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3328, 564, 0, '1', -16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3329, 564, 1, '2', -12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3330, 564, 2, '3', -6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3331, 564, 3, '4', 0, 0, 6350, 0);
INSERT INTO MP_EquipmentSection VALUES(3332, 564, 4, '5', 6477, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3333, 564, 5, '6', 12446, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3334, 564, 6, '7', 16637, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3335, 564, 9, 'R', 18288, 0, 254, 1);
INSERT INTO MP_EquipmentSection VALUES(3336, 565, 8, 'L', -18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3337, 565, 0, '1', -16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3338, 565, 1, '2', -12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3339, 565, 2, '3', -6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3340, 565, 3, '4', 0, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3341, 565, 4, '5', 6477, 0, 6477, 0);
INSERT INTO MP_EquipmentSection VALUES(3342, 565, 5, '6', 12383, 0, 5334, 0);
INSERT INTO MP_EquipmentSection VALUES(3343, 565, 6, '7', 16574, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3344, 565, 9, 'R', 18288, 0, 381, 1);
INSERT INTO MP_EquipmentSection VALUES(3345, 566, 8, 'L', -18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3346, 566, 0, '1', -16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3347, 566, 1, '2', -12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3348, 566, 2, '3', -6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3349, 566, 3, '4', 0, 0, 6096, 0);
INSERT INTO MP_EquipmentSection VALUES(3350, 566, 4, '5', 6350, 0, 6604, 0);
INSERT INTO MP_EquipmentSection VALUES(3351, 566, 5, '6', 12446, 0, 5588, 0);
INSERT INTO MP_EquipmentSection VALUES(3352, 566, 6, '7', 16764, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3353, 566, 9, 'R', 18542, 0, 508, 1);
INSERT INTO MP_EquipmentSection VALUES(3354, 567, 8, 'L', -18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3355, 567, 0, '1', -16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3356, 567, 1, '2', -12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3357, 567, 2, '3', -6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3358, 567, 3, '4', 0, 0, 6000, 0);
INSERT INTO MP_EquipmentSection VALUES(3359, 567, 4, '5', 6500, 0, 7000, 0);
INSERT INTO MP_EquipmentSection VALUES(3360, 567, 5, '6', 12500, 0, 5000, 0);
INSERT INTO MP_EquipmentSection VALUES(3361, 567, 6, '7', 16500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3362, 567, 9, 'R', 18250, 0, 500, 1);
INSERT INTO MP_EquipmentSection VALUES(3363, 568, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3364, 568, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3365, 569, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3366, 569, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3367, 570, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3368, 570, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3369, 571, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3370, 571, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3371, 572, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3372, 572, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3373, 573, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3374, 573, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3375, 575, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3376, 575, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3377, 576, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3378, 576, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3379, 577, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3380, 577, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3381, 578, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3382, 578, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3383, 579, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3384, 579, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3385, 580, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3386, 580, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3387, 581, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3388, 581, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3389, 582, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3390, 582, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3391, 583, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3392, 583, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3393, 584, 0, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3394, 584, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3395, 585, 0, '1', 0, 0, 21336, 0);
INSERT INTO MP_EquipmentSection VALUES(3396, 585, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3397, 586, 0, '1', 0, 0, 24384, 0);
INSERT INTO MP_EquipmentSection VALUES(3398, 586, 1, '2', 0, 0, 610, 0);
INSERT INTO MP_EquipmentSection VALUES(3399, 470, 1, 'SPN', 0, 0, 27432, 0);
INSERT INTO MP_EquipmentSection VALUES(3400, 435, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3401, 482, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3402, 485, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3403, 488, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3404, 442, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3405, 468, 1, 'SPN', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3406, 587, 0, '1', -11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(3407, 587, 1, '2', -7429, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3408, 587, 2, '3', -3619, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3409, 587, 3, '4', 0, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3410, 587, 4, '5', 3619, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3411, 587, 5, '6', 7429, 0, 3810, 0);
INSERT INTO MP_EquipmentSection VALUES(3412, 587, 6, '7', 11525, 0, 4382, 0);
INSERT INTO MP_EquipmentSection VALUES(3413, 588, 0, '1', -13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3414, 588, 1, '2', -12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3415, 588, 2, '3', -11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3416, 588, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3417, 588, 4, '5', -8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3418, 588, 5, '6', -5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3419, 588, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3420, 588, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3421, 588, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3422, 588, 9, '10', 5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3423, 588, 10, '11', 8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3424, 588, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3425, 588, 12, '13', 11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3426, 588, 13, '14', 12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3427, 588, 14, '15', 13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3429, 589, 0, '1', -14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3430, 589, 1, '2', -13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3431, 589, 2, '3', -11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3432, 589, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3433, 589, 4, '5', -8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3434, 589, 5, '6', -5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3435, 589, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3436, 589, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3437, 589, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3438, 589, 9, '10', 5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3439, 589, 10, '11', 8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3440, 589, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3441, 589, 12, '13', 11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3442, 589, 13, '14', 13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3458, 589, 14, '15', 14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3459, 591, 0, '1', -17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3460, 591, 1, '2', -15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3461, 591, 2, '3', -13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3462, 591, 3, '4', -10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3463, 591, 4, '5', -8763, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3464, 591, 5, '6', -6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3465, 591, 6, '7', -3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3466, 591, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3467, 591, 8, '9', 3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3468, 591, 9, '10', 6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3469, 591, 10, '11', 8763, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3470, 591, 11, '12', 10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3471, 591, 12, '13', 13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3472, 591, 13, '14', 15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3473, 591, 14, '15', 17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3474, 592, 0, '1', -13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3475, 596, 0, '1', -13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3476, 596, 1, '2', -12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3477, 596, 2, '3', -11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3478, 596, 3, '4', -9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3479, 596, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3480, 596, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3481, 596, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3482, 596, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3483, 596, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3484, 596, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3485, 596, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3486, 596, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3487, 596, 12, '13', 9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3488, 596, 13, '14', 11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3489, 596, 14, '15', 12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3490, 596, 15, '16', 13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3491, 597, 0, '1', -14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3492, 597, 1, '2', -13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3493, 597, 2, '3', -11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3494, 597, 3, '4', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3495, 597, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3496, 597, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3497, 597, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3498, 597, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3499, 597, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3500, 597, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3501, 597, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3502, 597, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3503, 597, 12, '13', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3504, 597, 13, '14', 11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3505, 597, 14, '15', 13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3506, 597, 15, '16', 14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3507, 598, 0, '1', -17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3508, 598, 1, '2', -15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3509, 598, 2, '3', -13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3510, 598, 3, '4', -11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3511, 598, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3512, 598, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3513, 598, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3514, 598, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3515, 598, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3516, 598, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3517, 598, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3518, 598, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3519, 598, 12, '13', 11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3520, 598, 13, '14', 13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3521, 598, 14, '15', 15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3522, 598, 15, '16', 17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3523, 599, 0, '1', -13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3524, 599, 1, '2', -12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3525, 599, 2, '3', -11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3526, 599, 3, '4', -9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3527, 599, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3528, 599, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3529, 599, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3530, 599, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3531, 599, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3532, 599, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3533, 599, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3534, 599, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3535, 599, 12, '13', 9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3536, 599, 13, '14', 11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3537, 599, 14, '15', 12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3538, 599, 15, '16', 13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3539, 600, 0, '1', -14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3540, 600, 1, '2', -13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3541, 600, 2, '3', -11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3542, 600, 3, '4', -10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3543, 600, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3544, 600, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3545, 600, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3546, 600, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3547, 600, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3548, 600, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3549, 600, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3550, 600, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3551, 600, 12, '13', 10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3552, 600, 13, '14', 11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3553, 600, 14, '15', 13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3554, 600, 15, '16', 14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3555, 601, 0, '1', -17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3556, 601, 1, '2', -15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3557, 601, 2, '3', -13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3558, 601, 3, '4', -11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3559, 601, 4, '5', -9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3560, 601, 5, '6', -6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3561, 601, 6, '7', -3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3562, 601, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3563, 601, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3564, 601, 9, '10', 3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3565, 601, 10, '11', 6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3566, 601, 11, '12', 9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3567, 601, 12, '13', 11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3568, 601, 13, '14', 13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3569, 601, 14, '15', 15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3570, 601, 15, '16', 17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3571, 592, 1, '2', -12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3572, 592, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3573, 592, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3574, 592, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3575, 592, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3576, 592, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3577, 592, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3578, 592, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3579, 592, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3580, 592, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3581, 592, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3582, 592, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3583, 592, 13, '14', 12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3584, 592, 14, '15', 13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3585, 593, 1, '2', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3586, 593, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3587, 593, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3588, 593, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3589, 593, 0, '1', -14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3590, 593, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3591, 593, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3592, 593, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3593, 593, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3594, 593, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3595, 593, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3596, 593, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3597, 593, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3598, 593, 13, '14', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3599, 593, 14, '15', 14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3600, 594, 0, '1', -17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3601, 594, 1, '2', -15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3602, 594, 2, '3', -13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3603, 594, 3, '4', -10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3604, 594, 4, '5', -8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3605, 594, 5, '6', -6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3606, 594, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3607, 594, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3608, 594, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3609, 594, 9, '10', 6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3610, 594, 10, '11', 8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3611, 594, 11, '12', 10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3612, 594, 12, '13', 13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3613, 594, 13, '14', 15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3614, 594, 14, '15', 17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3615, 603, 1, '1', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3616, 603, 2, '2', 0, 0, 18288, 0);
INSERT INTO MP_EquipmentSection VALUES(3617, 604, 0, '1', -13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3618, 604, 1, '2', -12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3619, 604, 2, '3', -11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3620, 604, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3621, 604, 4, '5', -8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3622, 604, 5, '6', -5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3623, 604, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3624, 604, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3625, 604, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3626, 604, 9, '10', 5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3627, 604, 10, '11', 8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3628, 604, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3629, 604, 12, '13', 11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3630, 604, 13, '14', 12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3631, 604, 14, '15', 13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3632, 605, 0, '1', -13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3633, 605, 1, '2', -12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3634, 605, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3635, 605, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3636, 605, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3637, 605, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3638, 605, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3639, 605, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3640, 605, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3641, 605, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3642, 605, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3643, 605, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3644, 605, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3645, 605, 13, '14', 12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3646, 605, 14, '15', 13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3647, 606, 0, '1', -13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3648, 606, 1, '2', -12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3649, 606, 2, '3', -11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3650, 606, 3, '4', -9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3651, 606, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3652, 606, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3653, 606, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3654, 606, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3655, 606, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3656, 606, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3657, 606, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3658, 606, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3659, 606, 12, '13', 9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3660, 606, 13, '14', 11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3661, 606, 14, '15', 12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3662, 606, 15, '16', 13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3663, 607, 0, '1', -13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3664, 607, 1, '2', -12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3665, 607, 2, '3', -11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3666, 607, 3, '4', -9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3667, 607, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3668, 607, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3669, 607, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3670, 607, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3671, 607, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3672, 607, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3673, 607, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3674, 607, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3675, 607, 12, '13', 9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3676, 607, 13, '14', 11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3677, 607, 14, '15', 12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3678, 607, 15, '16', 13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3681, 608, 0, '1', -14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3682, 608, 1, '2', -13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3683, 608, 2, '3', -11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3684, 608, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3685, 608, 4, '5', -8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3686, 608, 5, '6', -5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3687, 608, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3688, 608, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3689, 608, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3690, 608, 9, '10', 5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3691, 608, 10, '11', 8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3692, 608, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3693, 608, 12, '13', 11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3694, 608, 13, '14', 13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3695, 608, 14, '15', 14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3696, 609, 0, '1', -14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3697, 609, 1, '2', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3698, 609, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3699, 609, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3700, 609, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3701, 609, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3702, 609, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3703, 609, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3704, 609, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3705, 609, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3706, 609, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3707, 609, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3708, 609, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3709, 609, 13, '14', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3710, 609, 14, '15', 14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3711, 610, 0, '1', -14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3712, 610, 1, '2', -13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3713, 610, 2, '3', -11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3714, 610, 3, '4', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3715, 610, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3716, 610, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3717, 610, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3718, 610, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3719, 610, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3720, 610, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3721, 610, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3722, 610, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3723, 610, 12, '13', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3724, 610, 13, '14', 11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3725, 610, 14, '15', 13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3726, 610, 15, '16', 14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3727, 611, 0, '1', -14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3728, 611, 1, '2', -13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3729, 611, 2, '3', -11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3730, 611, 3, '4', -10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3731, 611, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3732, 611, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3733, 611, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3734, 611, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3735, 611, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3736, 611, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3737, 611, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3738, 611, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3739, 611, 12, '13', 10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3740, 611, 13, '14', 11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3741, 611, 14, '15', 13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3742, 611, 15, '16', 14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3743, 612, 0, '1', -17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3744, 612, 1, '2', -15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3745, 612, 2, '3', -13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3746, 612, 3, '4', -10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3747, 612, 4, '5', -8763, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3748, 612, 5, '6', -6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3749, 612, 6, '7', -3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3750, 612, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3751, 612, 8, '9', 3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3752, 612, 9, '10', 6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3753, 612, 10, '11', 8762, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3754, 612, 11, '12', 10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3755, 612, 13, '14', 15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3756, 612, 14, '15', 17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3757, 613, 0, '1', -17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3758, 613, 1, '2', -15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3759, 613, 2, '3', -13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3760, 613, 4, '5', -8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3761, 613, 3, '4', -10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3762, 613, 5, '6', -6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3763, 613, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3764, 613, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3765, 613, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3766, 613, 9, '10', 6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3767, 613, 10, '11', 8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3768, 613, 11, '12', 10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3769, 613, 12, '13', 13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3770, 613, 13, '14', 15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3771, 613, 14, '15', 17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3772, 614, 0, '1', -17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3773, 614, 1, '2', -15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3774, 614, 2, '3', -13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3775, 614, 3, '4', -11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3776, 614, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3777, 614, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3778, 614, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3779, 614, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3780, 614, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3781, 614, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3782, 614, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3783, 614, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3784, 614, 12, '13', 11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3785, 614, 13, '14', 13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3786, 614, 14, '15', 15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3787, 614, 15, '16', 17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3788, 615, 0, '1', -17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3789, 615, 1, '2', -15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3790, 615, 2, '3', -13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3791, 615, 3, '4', -11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3792, 615, 4, '5', -9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3793, 615, 5, '6', -6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3794, 615, 6, '7', -3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3795, 615, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3796, 615, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3797, 615, 9, '10', 3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3798, 615, 10, '11', 6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3799, 615, 11, '12', 9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3800, 615, 12, '13', 11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3801, 615, 13, '14', 13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3802, 615, 14, '15', 15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3803, 615, 15, '16', 17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3808, 619, 0, '1', -13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3809, 619, 14, '15', 13335, 0, 508, 0);
INSERT INTO MP_EquipmentSection VALUES(3810, 619, 1, '2', -12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3811, 619, 13, '14', 12573, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3812, 619, 2, '3', -11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3813, 619, 12, '13', 11430, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3814, 619, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3815, 619, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3816, 619, 4, '5', -8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3817, 619, 10, '11', 8128, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3818, 619, 5, '6', -5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3819, 619, 9, '10', 5715, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(3820, 619, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3821, 619, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3822, 619, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3823, 620, 0, '1', -13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3824, 620, 14, '15', 13335, 0, 381, 0);
INSERT INTO MP_EquipmentSection VALUES(3825, 620, 1, '2', -12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3826, 620, 13, '14', 12764, 0, 762, 0);
INSERT INTO MP_EquipmentSection VALUES(3827, 620, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3828, 620, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3829, 620, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3830, 620, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3831, 620, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3832, 620, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3833, 620, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3834, 620, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3835, 620, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3836, 620, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3837, 620, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3838, 621, 0, '1', -13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3839, 621, 15, '16', 13208, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3840, 621, 1, '2', -12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3841, 621, 14, '15', 12192, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3842, 621, 2, '3', -11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3843, 621, 13, '14', 11176, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3844, 621, 3, '4', -9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3845, 621, 12, '13', 9906, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3846, 621, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3847, 621, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3848, 621, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3849, 621, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3850, 621, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3851, 621, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3852, 621, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3853, 621, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3854, 622, 0, '1', -13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3855, 622, 1, '2', -12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3856, 622, 2, '3', -11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3857, 622, 3, '4', -9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3858, 622, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3859, 622, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3860, 622, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3861, 622, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3862, 622, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3863, 622, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3864, 622, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3865, 622, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3866, 622, 12, '13', 9750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3867, 622, 13, '14', 11000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3868, 622, 14, '15', 12000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3869, 622, 15, '16', 13000, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3870, 623, 0, '1', -14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3871, 623, 14, '15', 14478, 0, 1270, 0);
INSERT INTO MP_EquipmentSection VALUES(3872, 623, 1, '2', -13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3873, 623, 13, '14', 13081, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3874, 623, 2, '3', -11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3875, 623, 12, '13', 11557, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3876, 623, 3, '4', -10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3877, 623, 11, '12', 10033, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3878, 623, 4, '5', -8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3879, 623, 10, '11', 8382, 0, 1778, 0);
INSERT INTO MP_EquipmentSection VALUES(3880, 623, 5, '6', -5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3881, 623, 9, '10', 5969, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3882, 623, 6, '7', -2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3883, 623, 8, '9', 2921, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3884, 623, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3885, 624, 0, '1', -14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3886, 624, 14, '15', 14478, 0, 1143, 0);
INSERT INTO MP_EquipmentSection VALUES(3887, 624, 1, '2', -13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3888, 624, 13, '14', 13145, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3889, 624, 2, '3', -11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3890, 624, 12, '13', 11621, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3891, 624, 3, '4', -10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3892, 624, 11, '12', 10097, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3893, 624, 4, '5', -8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3894, 624, 10, '11', 8192, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3895, 624, 5, '6', -5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3896, 624, 9, '10', 5906, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3897, 624, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3898, 624, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3899, 624, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3900, 625, 0, '1', -14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3901, 625, 15, '16', 14732, 0, 1016, 0);
INSERT INTO MP_EquipmentSection VALUES(3902, 625, 1, '2', -13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3903, 625, 14, '15', 13462, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3904, 625, 2, '3', -11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3905, 625, 13, '14', 11938, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3906, 625, 3, '4', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3907, 625, 12, '13', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3908, 625, 4, '5', -8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3909, 625, 11, '12', 8382, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3910, 625, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3911, 625, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3912, 625, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3913, 625, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3914, 625, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3915, 625, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3916, 626, 0, '1', -14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3917, 626, 1, '2', -13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3918, 626, 2, '3', -11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3919, 626, 3, '4', -10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3920, 626, 4, '5', -8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3921, 626, 5, '6', -6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3922, 626, 6, '7', -3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3923, 626, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3924, 626, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3925, 626, 9, '10', 3000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3926, 626, 10, '11', 6000, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3927, 626, 11, '12', 8250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3928, 626, 12, '13', 10000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3929, 626, 13, '14', 11750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3930, 626, 14, '15', 13250, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3931, 626, 15, '16', 14500, 0, 1000, 0);
INSERT INTO MP_EquipmentSection VALUES(3932, 627, 0, '1', -17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3933, 627, 1, '2', -15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3934, 627, 13, '14', 15113, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3935, 627, 14, '15', 17145, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3936, 627, 2, '3', -13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3937, 627, 12, '13', 13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3938, 627, 3, '4', -10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3939, 627, 11, '12', 10922, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3940, 627, 4, '5', -8763, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3941, 627, 10, '11', 8763, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3942, 627, 5, '6', -6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3943, 627, 9, '10', 6223, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3944, 627, 6, '7', -3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3945, 627, 8, '9', 3048, 0, 3302, 0);
INSERT INTO MP_EquipmentSection VALUES(3946, 627, 7, '8', 0, 0, 2794, 0);
INSERT INTO MP_EquipmentSection VALUES(3947, 628, 0, '1', -17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3948, 628, 14, '15', 17336, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3949, 628, 1, '2', -15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3950, 628, 13, '14', 15431, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3951, 628, 2, '3', -13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3952, 628, 12, '13', 13145, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3953, 628, 3, '4', -10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3954, 628, 11, '12', 10859, 0, 2286, 0);
INSERT INTO MP_EquipmentSection VALUES(3955, 628, 4, '5', -8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3956, 628, 10, '11', 8954, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3957, 628, 5, '6', -6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3958, 628, 9, '10', 6477, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3959, 628, 6, '7', -3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3960, 628, 8, '9', 3048, 0, 3429, 0);
INSERT INTO MP_EquipmentSection VALUES(3961, 628, 7, '8', 0, 0, 2667, 0);
INSERT INTO MP_EquipmentSection VALUES(3962, 629, 0, '1', -17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3963, 629, 15, '16', 17526, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3964, 629, 1, '2', -15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3965, 629, 14, '15', 15748, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3966, 629, 2, '3', -13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3967, 629, 13, '14', 13716, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3968, 629, 3, '4', -11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3969, 629, 12, '13', 11176, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3970, 629, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3971, 629, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(3972, 629, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3973, 629, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3974, 629, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3975, 629, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(3976, 629, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3977, 629, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(3978, 630, 0, '1', -17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3979, 630, 1, '2', -15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3980, 630, 2, '3', -13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3981, 630, 3, '4', -11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3982, 630, 4, '5', -9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3983, 630, 5, '6', -6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3984, 630, 6, '7', -3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3985, 630, 7, '8', -750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3986, 630, 8, '9', 750, 0, 1500, 0);
INSERT INTO MP_EquipmentSection VALUES(3987, 630, 9, '10', 3250, 0, 3500, 0);
INSERT INTO MP_EquipmentSection VALUES(3988, 630, 10, '11', 6500, 0, 3000, 0);
INSERT INTO MP_EquipmentSection VALUES(3989, 630, 11, '12', 9000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3990, 630, 12, '13', 11000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3991, 630, 13, '14', 13000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3992, 630, 14, '15', 15000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(3993, 630, 15, '16', 17000, 0, 2000, 0);
INSERT INTO MP_EquipmentSection VALUES(4045, 612, 12, '13', 13081, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4048, 637, 0, '1', -16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4049, 637, 1, '2', -13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4050, 637, 2, '3', -10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4051, 637, 3, '4', -8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4052, 637, 4, '5', -6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4053, 637, 5, '6', -4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4054, 637, 6, '7', -2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4055, 637, 7, '8', 0, 0, 2413, 0);
INSERT INTO MP_EquipmentSection VALUES(4056, 637, 8, '9', 2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4057, 637, 9, '10', 4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4058, 637, 10, '11', 6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4059, 637, 11, '12', 8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4060, 637, 12, '13', 10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4061, 637, 13, '14', 13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4062, 637, 14, '15', 16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4063, 638, 0, '1', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4064, 638, 1, '2', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4065, 638, 2, '3', -13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4066, 638, 3, '4', -10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4067, 638, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4068, 638, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4069, 638, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4070, 638, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4071, 638, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4072, 638, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4073, 638, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4074, 638, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4075, 638, 12, '13', 10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4076, 638, 13, '14', 13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4077, 638, 14, '15', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4078, 638, 15, '16', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4079, 639, 0, '1', -19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4080, 639, 1, '2', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4081, 639, 2, '3', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4082, 639, 3, '4', -12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4083, 639, 4, '5', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4084, 639, 5, '6', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4085, 639, 6, '7', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4086, 639, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4087, 639, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4088, 639, 9, '10', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4089, 639, 10, '11', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4090, 639, 11, '12', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4091, 639, 12, '13', 12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4092, 639, 13, '14', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4093, 639, 14, '15', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4094, 639, 15, '16', 19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4095, 640, 0, '1', -16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4096, 640, 1, '2', -13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4097, 640, 2, '3', -10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4098, 640, 3, '4', -8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4099, 640, 4, '5', -6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4100, 640, 5, '6', -4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4101, 640, 6, '7', -2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4102, 640, 7, '8', 0, 0, 2413, 0);
INSERT INTO MP_EquipmentSection VALUES(4103, 640, 8, '9', 2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4104, 640, 9, '10', 4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4105, 640, 10, '11', 6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4106, 640, 11, '12', 8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4107, 640, 12, '13', 10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4108, 640, 13, '14', 13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4109, 640, 14, '15', 16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4110, 641, 0, '1', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4111, 641, 1, '2', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4112, 641, 2, '3', -13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4113, 641, 3, '4', -10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4114, 641, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4115, 641, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4116, 641, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4117, 641, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4118, 641, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4119, 641, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4120, 641, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4121, 641, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4122, 641, 12, '13', 10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4123, 641, 13, '14', 13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4124, 641, 14, '15', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4125, 641, 15, '16', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4126, 642, 0, '1', -19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4127, 642, 1, '2', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4128, 642, 2, '3', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4129, 642, 3, '4', -12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4130, 642, 4, '5', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4131, 642, 5, '6', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4132, 642, 6, '7', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4133, 642, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4134, 642, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4135, 642, 9, '10', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4136, 642, 10, '11', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4137, 642, 11, '12', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4138, 642, 12, '13', 12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4139, 642, 13, '14', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4140, 642, 14, '15', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4141, 642, 15, '16', 19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4142, 643, 0, '1', -16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4143, 643, 1, '2', -13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4144, 643, 2, '3', -10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4145, 643, 3, '4', -8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4146, 643, 4, '5', -6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4147, 643, 5, '6', -4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4148, 643, 6, '7', -2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4149, 643, 7, '8', 0, 0, 2413, 0);
INSERT INTO MP_EquipmentSection VALUES(4150, 643, 8, '9', 2170, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4151, 643, 9, '10', 4100, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4152, 643, 10, '11', 6520, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4153, 643, 11, '12', 8930, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4154, 643, 12, '13', 10860, 0, 1930, 0);
INSERT INTO MP_EquipmentSection VALUES(4155, 643, 13, '14', 13510, 0, 3378, 0);
INSERT INTO MP_EquipmentSection VALUES(4156, 643, 14, '15', 16650, 0, 2896, 0);
INSERT INTO MP_EquipmentSection VALUES(4157, 644, 0, '1', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4158, 644, 1, '2', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4159, 644, 2, '3', -13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4160, 644, 3, '4', -10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4161, 644, 4, '5', -8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4162, 644, 5, '6', -6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4163, 644, 6, '7', -3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4164, 644, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4165, 644, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4166, 644, 9, '10', 3048, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4167, 644, 10, '11', 6096, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4168, 644, 11, '12', 8636, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4169, 644, 12, '13', 10922, 0, 2540, 0);
INSERT INTO MP_EquipmentSection VALUES(4170, 644, 13, '14', 13208, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4171, 644, 14, '15', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4172, 644, 15, '16', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4173, 645, 0, '1', -19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4174, 645, 1, '2', -17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4175, 645, 2, '3', -15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4176, 645, 3, '4', -12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4177, 645, 4, '5', -10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4178, 645, 5, '6', -7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4179, 645, 6, '7', -3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4180, 645, 7, '8', -762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4181, 645, 8, '9', 762, 0, 1524, 0);
INSERT INTO MP_EquipmentSection VALUES(4182, 645, 9, '10', 3810, 0, 4572, 0);
INSERT INTO MP_EquipmentSection VALUES(4183, 645, 10, '11', 7620, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4184, 645, 11, '12', 10160, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4185, 645, 12, '13', 12700, 0, 3048, 0);
INSERT INTO MP_EquipmentSection VALUES(4186, 645, 13, '14', 15240, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4187, 645, 14, '15', 17272, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4188, 645, 15, '16', 19304, 0, 2032, 0);
INSERT INTO MP_EquipmentSection VALUES(4189, 380, 0, 'L', -11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4190, 380, 8, 'R', 11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4191, 381, 0, 'L', -11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4192, 381, 8, 'R', 11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4193, 382, 0, 'L', -11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4194, 382, 8, 'R', 11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4195, 383, 0, 'L', -11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4196, 383, 8, 'R', 11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4197, 384, 0, 'L', -13721, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4198, 384, 8, 'R', 13721, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4199, 385, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4200, 385, 8, 'R', 14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4201, 386, 0, 'L', -11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4202, 386, 8, 'R', 11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4203, 387, 0, 'L', -11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4204, 387, 8, 'R', 11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4205, 388, 0, 'L', -11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4206, 388, 8, 'R', 11430, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4207, 389, 0, 'L', -11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4208, 389, 8, 'R', 11811, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4209, 390, 0, 'L', -13721, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4210, 390, 8, 'R', 13721, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4211, 391, 0, 'L', -14097, 0, 762, 1);
INSERT INTO MP_EquipmentSection VALUES(4212, 391, 8, 'R', 14097, 0, 762, 1);

END TRANSACTION;
PRAGMA FOREIGN_KEYS = ON;

