#!/bin/sh

set -x

if [ -f /etc/init.d/watchdog ]; then
	/etc/init.d/watchdog stop
fi

PLATFORM="VIPER4"
if [ -f /etc/raven/platform ]; then
	PLATFORM=`cat /etc/raven/platform`
fi

if [ $PLATFORM == "VIPER4" ]; then
	chvt 1
	cat /usr/bin/raven/userFiles/softwareUpdates/notAvailable.fb > /dev/fb0
	sleep 10
	reboot
	exit 1
fi

#<copy destination="/var/lib/smart/revertscript.xml" source="*softwareUpdateDir/revertscript.xml"/>
#<copy destination="*mainDirectory/revertscript.xml" source="*softwareUpdateDir/revertscript.xml"/>	
if [ ! -f /usr/bin/raven/userFiles/softwareUpdates/${PLATFORM}/revertscript.xml ]; then
	echo "Error revert script missing for platform ${PLATFORM}!"
	exit 1
else
	cp /usr/bin/raven/userFiles/softwareUpdates/${PLATFORM}/revertscript.xml /var/lib/smart/revertscript.xml
	cp /usr/bin/raven/userFiles/softwareUpdates/${PLATFORM}/revertscript.xml /usr/bin/raven/revertscript.xml
fi

#<exec source="/bin/chmod">
#	<arg>"755"</arg>
#	<arg>"/usr/bin/raven/userFiles/softwareUpdates/0001-ota-fwinstall.sh"</arg>
#</exec>
#<exec source="/usr/bin/raven/userFiles/softwareUpdates/0001-ota-fwinstall.sh"></exec>
for files in `ls -p /usr/bin/raven/userFiles/softwareUpdates/patches/${PLATFORM} | grep -v /`; do
	if [ -f /usr/bin/raven/userFiles/softwareUpdates/patches/${PLATFORM}/${files} ]; then
		chmod 755 /usr/bin/raven/userFiles/softwareUpdates/patches/${PLATFORM}/${files}
		/usr/bin/raven/userFiles/softwareUpdates/patches/${PLATFORM}/${files}
	fi
done

#<exec source="/usr/bin/nohup">
#	<arg>"/etc/init.d/fwinstall"</arg>
#	<arg>"start"</arg>
#	<arg>"/usr/bin/raven/userFiles/softwareUpdates/userFiles/viper4_2.2.0.517_x86.zip"</arg>
#</exec>
for zip in `ls -p /usr/bin/raven/userFiles/softwareUpdates/userFiles/${PLATFORM} | grep -v /`; do
	if [ -f /usr/bin/raven/userFiles/softwareUpdates/userFiles/${PLATFORM}/${zip} ]; then
	    logger -s "Beginning fwinstall: /etc/init.d/fwinstall start /usr/bin/raven/userFiles/softwareUpdates/userFiles/${PLATFORM}/${zip}"
		/usr/bin/nohup /etc/init.d/fwinstall start /usr/bin/raven/userFiles/softwareUpdates/userFiles/${PLATFORM}/${zip} > /var/log/usb_updater.log 2>&1 &
		
		RET=$?
        logger -s "Launched [$RET]"
	fi
done

