#!/bin/sh

#set -x

echo Testing SN:$3 Running $2 @ $1

TestCAN () {
ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null root@$1 "cd /usr/bin/factory/scripts/fixture; ./src/CANbus.sh /var/log/factory/CANbus.log setup"
}

TestSerial () {
ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null root@$1 "cd /usr/bin/factory/scripts/fixture; ./src/Main_Connection.sh /var/log/factory/MainConn.log setup"
}

TestMicro () {
ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null root@$1 "cd /usr/bin/factory/scripts/fixture; ./src/MicroSelftest.sh"
}

SetSerialNumber () {
ssh -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null root@$1 "cd /usr/bin/factory/scripts/fixture; ./src/StoreSerialNumber.sh $2"
}

UpdateTestCode () {
scp -oStrictHostKeyChecking=no -oUserKnownHostsFile=/dev/null /usr/bin/factory/scripts/fixture/src/Main_Connection.sh root@$1:/usr/bin/factory/scripts/fixture/src/Main_Connection.sh
}

case "$2" in
        CAN)
                TestCAN $1
                ;;
        Serial)
                TestSerial $1
                ;;
		Micro)
				TestMicro $1 
				;;
        SerialNum)
                SetSerialNumber $1 $3
               ;;
        ALL)
		        UpdateTestCode $1
                SetSerialNumber $1 $3
	        	TestMicro $1
                TestCAN $1
                TestSerial $1
                ;;
        *)
                echo "Unknown test"
                ;;
esac
