#!bin/bash
#set -x # debug

DIR="$1" # First parameter is log file path

echo 
echo "Testing speakers...playing sound."
echo

aplay -q ./src/beep.wav # Play sound 

while true; do
	echo "Did a sound play? Y/N: "
	read -t 5 yn # Prompt user for test results

	if [ "$yn" = "" ]; then
		echo External Speaker Test: FAIL 1>>$DIR; echo; break # If test times out, assume failure
	fi 

	case $yn in
		Y) echo External Speaker Test: PASS 1>>$DIR; break;; # Write pass to log file.
		y) echo External Speaker Test: PASS 1>>$DIR; break;;
		N) echo External Speaker Test: FAIL 1>>$DIR; break;; # Write fail to log file.
		n) echo External Speaker Test: FAIL 1>>$DIR; break;;
		* ) echo; echo Invalid input, try again.; echo # In case of improper input, stay in while loop
	esac
done
echo
