#!/bin/bash
#set -x #debug

TESTRESULTS=`dbus-send --system --print-reply --dest=com.raven.hardware.microcontroller.v1 /com/raven/hardware/microcontroller/v1/micro com.raven.hardware.microcontroller.v1.micro.runSelftest | grep uint32 | awk '{ print $2 }'`

#default to all errors
TESTNUMBER=0
INITFLAGS=0xFFFFFFFF
POWERFLAGS=0xFFFFFFFF

for test in $TESTRESULTS
do
	if [ "$TESTNUMBER" == "0" ]; then
		INITFLAGS=$test
		TESTNUMBER=1
	else
		POWERFLAGS=$test
	fi
done

printf "Init Flags = 0x%x\n" $INITFLAGS
printf "Power Flags = 0x%x\n" $POWERFLAGS
echo ""

if [ "$INITFLAGS" != "0" ] || [ "$POWERFLAGS" != "0" ]; then
	echo "Micro Selftest: FAILED"
else
	echo "Micro Selftest: PASSED"
fi

##################################################INIT FLAGS

MICRO_PWR_INIT_ERROR=0x0001
if [ `echo $((($INITFLAGS & MICRO_PWR_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_PWR_INIT_ERROR"
fi

MICRO_IO_INIT_ERROR=0x0002
if [ `echo $((($INITFLAGS & MICRO_IO_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_IO_INIT_ERROR"
fi

MICRO_LED_INIT_ERROR=0x0004
if [ `echo $((($INITFLAGS & MICRO_LED_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_LED_INIT_ERROR"
fi

MICRO_ADC_INIT_ERROR=0x0008
if [ `echo $((($INITFLAGS & MICRO_ADC_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_ADC_INIT_ERROR"
fi

MICRO_USART_INIT_ERROR=0x0010
if [ `echo $((($INITFLAGS & MICRO_USART_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_USART_INIT_ERROR"
fi

MICRO_HDLC_INIT_ERROR=0x0020
if [ `echo $((($INITFLAGS & MICRO_HDLC_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_HDLC_INIT_ERROR"
fi

MICRO_LCD_BACKLIGHT_INIT_ERROR=0x0040
if [ `echo $((($INITFLAGS & MICRO_LCD_BACKLIGHT_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_LCD_BACKLIGHT_INIT_ERROR"
fi

MICRO_I2CX_INIT_ERROR=0x0080
if [ `echo $((($INITFLAGS & MICRO_I2CX_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_I2CX_INIT_ERROR"
fi

MICRO_PCA9575_INIT_ERROR=0x0100
if [ `echo $((($INITFLAGS & MICRO_PCA9575_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_PCA9575_INIT_ERROR"
fi

MICRO_IDT5V49EE704_INIT_ERROR=0x0200
if [ `echo $((($INITFLAGS & MICRO_IDT5V49EE704_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_IDT5V49EE704_INIT_ERROR"
fi

MICRO_AD128D818_INIT_ERROR=0x0400
if [ `echo $((($INITFLAGS & MICRO_AD128D818_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_AD128D818_INIT_ERROR"
fi

MICRO_WATCHDOG_RESET_ERROR=0x0800
if [ `echo $((($INITFLAGS & MICRO_WATCHDOG_RESET_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_WATCHDOG_RESET_ERROR"
fi

MICRO_EEPROM_INIT_ERROR=0x1000
if [ `echo $((($INITFLAGS & MICRO_EEPROM_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_EEPROM_INIT_ERROR"
fi

MICRO_RTC_INIT_ERROR=0x2000
if [ `echo $((($INITFLAGS & MICRO_RTC_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_RTC_INIT_ERROR"
fi

MICRO_CLK_INIT_ERROR=0x4000
if [ `echo $((($INITFLAGS & MICRO_CLK_INIT_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_CLK_INIT_ERROR"
fi

MICRO_UNKNOWN_ERROR=0xFFFF8000
if [ `echo $((($INITFLAGS & MICRO_UNKNOWN_ERROR) != 0))` -eq 1 ]; then	
	echo "Error: MICRO_UNKNOWN_ERROR"
fi

#######################################################POWER FLAGS

FLAG_24V_INPUT_CURRENT_UNDERLIMIT=0x1
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_CURRENT_UNDERLIMIT"
fi

FLAG_24V_INPUT_PROT_VOLTAGE_UNDERLIMIT=0x2
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_PROT_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_PROT_VOLTAGE_UNDERLIMIT"
fi

FLAG_16V_BOOST_UNDERLIMIT=0x4
if [ `echo $((($POWERFLAGS & FLAG_16V_BOOST_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_16V_BOOST_UNDERLIMIT"
fi

FLAG_24V_INPUT_VOLTAGE_UNDERLIMIT=0x8
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_VOLTAGE_UNDERLIMIT"
fi

FLAG_24V_OUTPUT_VOLTAGE_UNDERLIMIT=0x10
if [ `echo $((($POWERFLAGS & FLAG_24V_OUTPUT_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_OUTPUT_VOLTAGE_UNDERLIMIT"
fi

FLAG_24V_OUTPUT_CURRENT_UNDERLIMIT=0x20
if [ `echo $((($POWERFLAGS & FLAG_24V_OUTPUT_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_OUTPUT_CURRENT_UNDERLIMIT"
fi

FLAG_12V_CURRENT_UNDERLIMIT=0x40
if [ `echo $((($POWERFLAGS & FLAG_12V_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CURRENT_UNDERLIMIT"
fi

FLAG_5V_CURRENT_UNDERLIMIT=0x80
if [ `echo $((($POWERFLAGS & FLAG_5V_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_5V_CURRENT_UNDERLIMIT"
fi

FLAG_24V_INPUT_CURRENT_OVERLIMIT=0x100
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_CURRENT_OVERLIMIT"
fi

FLAG_24V_INPUT_PROT_VOLTAGE_OVERLIMIT=0x200
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_PROT_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_PROT_VOLTAGE_OVERLIMIT"
fi

FLAG_16V_BOOST_OVERLIMIT=0x400
if [ `echo $((($POWERFLAGS & FLAG_16V_BOOST_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_16V_BOOST_OVERLIMIT"
fi

FLAG_24V_INPUT_VOLTAGE_OVERLIMIT=0x800
if [ `echo $((($POWERFLAGS & FLAG_24V_INPUT_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_INPUT_VOLTAGE_OVERLIMIT"
fi

FLAG_24V_OUTPUT_VOLTAGE_OVERLIMIT=0x1000
if [ `echo $((($POWERFLAGS & FLAG_24V_OUTPUT_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_OUTPUT_VOLTAGE_OVERLIMIT"
fi

FLAG_24V_OUTPUT_CURRENT_OVERLIMIT=0x2000
if [ `echo $((($POWERFLAGS & FLAG_24V_OUTPUT_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_24V_OUTPUT_CURRENT_OVERLIMIT"
fi

FLAG_12V_CURRENT_OVERLIMIT=0x4000
if [ `echo $((($POWERFLAGS & FLAG_12V_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CURRENT_OVERLIMIT"
fi

FLAG_5V_CURRENT_OVERLIMIT=0x8000
if [ `echo $((($POWERFLAGS & FLAG_5V_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_5V_CURRENT_OVERLIMIT"
fi

FLAG_16V_BOOST_CURRENT_UNDERLIMIT=0x10000
if [ `echo $((($POWERFLAGS & FLAG_16V_BOOST_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_16V_BOOST_CURRENT_UNDERLIMIT"
fi

FLAG_12V_CAMERA_CURRENT_UNDERLIMIT=0x20000
if [ `echo $((($POWERFLAGS & FLAG_12V_CAMERA_CURRENT_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CAMERA_CURRENT_UNDERLIMIT"
fi

FLAG_36V_LCD_VOLTAGE_UNDERLIMIT=0x40000
if [ `echo $((($POWERFLAGS & FLAG_36V_LCD_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_36V_LCD_VOLTAGE_UNDERLIMIT"
fi

FLAG_12V_CAMERA_VOLTAGE_UNDERLIMIT=0x80000
if [ `echo $((($POWERFLAGS & FLAG_12V_CAMERA_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CAMERA_VOLTAGE_UNDERLIMIT"
fi

FLAG_12V_VOLTAGE_UNDERLIMIT=0x100000
if [ `echo $((($POWERFLAGS & FLAG_12V_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_VOLTAGE_UNDERLIMIT"
fi

FLAG_5V_VOLTAGE_UNDERLIMIT=0x200000
if [ `echo $((($POWERFLAGS & FLAG_5V_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_5V_VOLTAGE_UNDERLIMIT"
fi

FLAG_3p3V_HP_VOLTAGE_UNDERLIMIT=0x400000
if [ `echo $((($POWERFLAGS & FLAG_3p3V_HP_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_3p3V_HP_VOLTAGE_UNDERLIMIT"
fi

FLAG_3p3V_SOM_VOLTAGE_UNDERLIMIT=0x800000
if [ `echo $((($POWERFLAGS & FLAG_3p3V_SOM_VOLTAGE_UNDERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_3p3V_SOM_VOLTAGE_UNDERLIMIT"
fi

FLAG_16V_BOOST_CURRENT_OVERLIMIT=0x1000000
if [ `echo $((($POWERFLAGS & FLAG_16V_BOOST_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_16V_BOOST_CURRENT_OVERLIMIT"
fi

FLAG_12V_CAMERA_CURRENT_OVERLIMIT=0x2000000
if [ `echo $((($POWERFLAGS & FLAG_12V_CAMERA_CURRENT_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CAMERA_CURRENT_OVERLIMIT"
fi

FLAG_36V_LCD_VOLTAGE_OVERLIMIT=0x4000000
if [ `echo $((($POWERFLAGS & FLAG_36V_LCD_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_36V_LCD_VOLTAGE_OVERLIMIT"
fi

FLAG_12V_CAMERA_VOLTAGE_OVERLIMIT=0x8000000
if [ `echo $((($POWERFLAGS & FLAG_12V_CAMERA_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_CAMERA_VOLTAGE_OVERLIMIT"
fi

FLAG_12V_VOLTAGE_OVERLIMIT=0x10000000
if [ `echo $((($POWERFLAGS & FLAG_12V_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_12V_VOLTAGE_OVERLIMIT"
fi

FLAG_5V_VOLTAGE_OVERLIMIT=0x20000000
if [ `echo $((($POWERFLAGS & FLAG_5V_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_5V_VOLTAGE_OVERLIMIT"
fi

FLAG_3p3V_HP_VOLTAGE_OVERLIMIT=0x40000000
if [ `echo $((($POWERFLAGS & FLAG_3p3V_HP_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_3p3V_HP_VOLTAGE_OVERLIMIT"
fi

FLAG_3p3V_SOM_VOLTAGE_OVERLIMIT=0x80000000
if [ `echo $((($POWERFLAGS & FLAG_3p3V_SOM_VOLTAGE_OVERLIMIT) != 0))` -eq 1 ]; then	
	echo "Error: FLAG_3p3V_SOM_VOLTAGE_OVERLIMIT"
fi

