#!/bin/bash
#set -x #debug

DIR="$1" # First parameter is log file path

BAUD="115200" # Set BAUD rate
MATCHSTRING="Viper4TestStringABCDEFGHIJKLMNOPQRSTUVWXYZ" # Create matchstring
TIMEOUT=2

# External loop backs: 
# COM A RX Data to COM B TX Data
# COM A TX Data to COM B RX Data
# COM C RX Data to COM D TX Data
# COM C TX Data to COM D RX Data

setbaud() { # Create function to set BAUD rate
	if [ -c $1 ]; then
		if [ "$2" ]; then
			stty -F $1 $2 $BAUD 
                else
			stty -F $1 $BAUD 
		fi
	else
		echo "$1 Doesn't exist"
	fi
}

COM_A=/dev/ttymxc0 # Set path for COM A
COM_B=/dev/ttyS2 # Set path for COM B
COM_C=/dev/ttyS1 # Set path for COM C
COM_D=/dev/ttyS0 # Set path for COM D

if [ "$2" = setup ]; then
	echo; echo Testing COM.....      # Tell user tests starting
#	echo -----COM----- 1>>$DIR # Print header to log file

	# Set BAUD rates for all ports
	setbaud $COM_A crtscts
	setbaud $COM_B
	setbaud $COM_C
	setbaud $COM_D
fi

case "$2" in
	run)
		RESULT=`perl -e "alarm $TIMEOUT; exec @ARGV" "cat $5"` # Look for input on port until time out
		RESULT2=`echo $RESULT | grep "$MATCHSTRING"`	# Compare received string and matchstring 
		if [ "$RESULT2" ]; then  
			echo Send $3, Receive $4: PASS		   # Write pass to user screen
#			echo Send $3, Receive $4: PASS 1>>$DIR # Write pass to log file
		else
			echo Send $3, Receive $4: FAIL		   # Write fail to user screen
#			echo Send $3, Receive $4: FAIL 1>>$DIR # Write fail to log file
		fi
	;;
	setup)
		for i in `seq 1 4`;
		do
			case "$i" in
			1) 	bash ./src/Main_Connection.sh $DIR run COM_A COM_B $COM_B & # Send recursive listening to background
				sleep 1
				echo $MATCHSTRING > $COM_A	# Send out matchstring
				#sleep 1
			;;

			2) 	bash ./src/Main_Connection.sh $DIR run COM_B COM_A $COM_A & # Send recursive listening to background
				sleep 1
				echo $MATCHSTRING > $COM_B # Send out matchstring
				#sleep 1
			;;

			3) 	bash ./src/Main_Connection.sh $DIR run COM_C COM_D $COM_D & # Send recursive listening to background
				sleep 1
				echo $MATCHSTRING > $COM_C # Send out matchstring
				#sleep 1
			;;

			4) 	bash ./src/Main_Connection.sh $DIR run COM_D COM_C $COM_C & # Send recursive listening to background
				sleep 1
				echo $MATCHSTRING > $COM_D # Send out matchstring
				#sleep 1
			;;
			esac
		done
#		sleep 1
#		echo ------------- 1>>$DIR # Print footer to log file
	;;
esac
