#!bin/bash
#set -x #debug

DIR="$1" # First parameter is log file path

if [ "$2" = setup ]; then
	echo; echo Testing GPS.....      # Tell user tests starting
fi

BAUD="115200" # Set BAUD rate
MATCHSTRING="Viper4TestStringABCDEFGHIJKLMNOPQRSTUVWXYZ" # Create matchstring
TIMEOUT=2

setbaud() { # Create function to set BAUD rate
	if [ -c $1 ]; then
		stty -F $1 $BAUD
	fi
}

COM_GPS=/dev/ttymxc2
#/dev/ttyS6 # Set path for COM A
#/dev/ttymxc2
# Set BAUD rates for all ports
setbaud $COM_GPS

case "$2" in
	run)
		RESULT=`perl -e "alarm $TIMEOUT; exec @ARGV" "cat $3"` # Look for input on port until time out
		RESULT2=`echo $RESULT | grep "$MATCHSTRING"`	# Compare received string and matchstring 
		if [ "$RESULT2" ]; then  
			echo GPS: PASS		   # Write pass to user screen
			echo GPS: PASS 1>>$DIR # Write pass to log file
		else
			echo GPS: FAIL		   # Write fail to user screen
			echo GPS: FAIL 1>>$DIR # Write fail to log file
		fi
	;;
	setup)	bash ./src/GPS.sh $DIR run $COM_GPS & # Send recursive listening to background
		sleep 1
		echo $MATCHSTRING > $COM_GPS	# Send out matchstring
		sleep 2
	;;
esac
