#!bin/bash
#set -x

DIR="$1" # First parameter is log file path
export DISPLAY=0:0 # Set display for mplayer
echo 
case "$2" in # Use case statement for recursion / optimization
	setup)
		for i in `seq 1 4`;
		do
			case "$i" in
			1) 	mplayer tv:// -tv device=/dev/video0:outfmt=yuy2:normid=3:width=352:height=240 &>/dev/null & # Silence mplayer output
				bash ./src/Cameras.sh $DIR run $i # Call user prompt recursively
			;;

			2)      mplayer tv:// -tv device=/dev/video1:outfmt=yuy2:normid=3:width=352:height=240 &>/dev/null & # Silence mplayer output
				bash ./src/Cameras.sh $DIR run $i # Call user prompt recursively
			;;

			3)	mplayer tv:// -tv device=/dev/video2:outfmt=yuy2:normid=3:width=352:height=240 &>/dev/null & # Silence mplayer output
				bash ./src/Cameras.sh $DIR run $i # Call user prompt recursively
			;;

			4)	mplayer tv:// -tv device=/dev/video3:outfmt=yuy2:normid=3:width=352:height=240 &>/dev/null & # Silence mplayer output
				bash ./src/Cameras.sh $DIR run $i # Call user prompt recursively
			;;
			esac
		done
	;;
	run)
		while true; do
			echo "Does camera "$3" work? Y/N: "
			read -t 5 yn # Prompt user for test results
			
			if [ "$yn" = "" ]; then
				echo "Camera "$3" Test: FAIL" 1>>$DIR; echo; break
			fi 
			
			case $yn in
				Y) echo "Camera "$3" Test: PASS" 1>>$DIR; break;; # Write pass to log file
				y) echo "Camera "$3" Test: PASS" 1>>$DIR; break;;
				N) echo "Camera "$3" Test: FAIL" 1>>$DIR; break;; # Write fail to log file
				n) echo "Camera "$3" Test: FAIL" 1>>$DIR; break;;
				* ) echo; echo Invalid input, try again.; echo # In case of improper input, stay in while loop
			esac
		done
	;;
esac
killall mplayer &>/dev/null
