#!/bin/bash
#set -x

DIR="$1" # First parameter is log file path
BAUD=250000 # Set BAUD rate
TIMEOUT=1	# Set TIMEOUT for sensing input

MESSAGE="-D AA55DEADBEEF -L 6" # Test messages
MATCHSTRING="AA 55 DE AD BE EF"

case "$2" in
	run) #First message is lost, capture the second
		 /usr/bin/cangen $MESSAGE -n 2 -g 1000 $4 &
			
		 RESULT=`perl -e "alarm $TIMEOUT; exec @ARGV" "/usr/bin/candump $3"` # Look for input on port until time out
		 RESULT_TRIM=`echo $RESULT | grep $3`					# Compare received string and matchstring 
		 RESULT2=`echo $RESULT_TRIM | grep "$MATCHSTRING"`

		 if [ "$RESULT2" ]; then  
			 echo Send: $4 Receive: $3 : PASS			# Write pass to user screen
#			 echo Send: $4 Receive: $3 : PASS 1>>$DIR	# Write pass to log file
		 else
			 echo Send: $4 Receive: $3 : FAIL			# Write fail to user screen
#			 echo Send: $4 Receive: $3 : FAIL 1>>$DIR	# Write fail to log file
		 fi

		 #sleep 1
	;;
	setup)  
		echo; echo Testing CAN.....
#		echo "-----CAN-----" 1>>$DIR # Write header to log file
		
		CAN_PORT_A="can0"
		CAN_PORT_B="can1"
		CAN_PORT_C="can2"
		CAN_PORT_D="can3"
		
		# Bring ports down to change setup
		ifconfig $CAN_PORT_A down
		ifconfig $CAN_PORT_B down 
		ifconfig $CAN_PORT_C down
		ifconfig $CAN_PORT_D down 
		#sleep 1 
		# Set up ports for tests
		ip link set $CAN_PORT_A up type can bitrate $BAUD
		ip link set $CAN_PORT_B up type can bitrate $BAUD
		ip link set $CAN_PORT_C up type can bitrate $BAUD
		ip link set $CAN_PORT_D up type can bitrate $BAUD
		#sleep 1
		# Bring ports back up
		ifconfig $CAN_PORT_A up
		ifconfig $CAN_PORT_B up
		ifconfig $CAN_PORT_C up
		ifconfig $CAN_PORT_D up
		sleep 1
		
		for i in `seq 1 4`;
		do
			case "$i" in
			1) 	bash ./src/CANbus.sh $DIR run $CAN_PORT_B $CAN_PORT_A
			;;

			2) 	bash ./src/CANbus.sh $DIR run $CAN_PORT_A $CAN_PORT_B
			;;
				
			3) 	bash ./src/CANbus.sh $DIR run $CAN_PORT_D $CAN_PORT_C
			;;

			4) 	bash ./src/CANbus.sh $DIR run $CAN_PORT_C $CAN_PORT_D
			;;
			esac
		done
#		echo ------------- 1>>$DIR # Write footer to log file
	;;
esac 

