#!/bin/bash
# set -x

#clear # Clear system screen

# Create date variable passed in from master computer
_now=$1
BARCODE=$2

# Kill jetstream
kill -9 $(pidof jetstream) &>/dev/null

# Get unit barcode number
#echo
#echo "Enter bar code #: "
#read BARCODE

# Ensure valid barcode?

# Test if log file folder exists. If not, create one
if [ ! -d "/log_files" ]; then
	mkdir -p log_files
fi

# Test if unit log folder exists. If not, create one
if [ ! -d "/log_files/$BARCODE" ]; then
	cd log_files
	mkdir -p $BARCODE
	cd ..
fi

LOGFILE=$BARCODE"_"$_now".log" # Make logfile name: barcode with time & date appended
DIR=./log_files/$BARCODE/$LOGFILE	# Create path to file to send to test scripts

echo ------------------------------ BEGIN LOG ------------------------------ 1>>$DIR # Write tests header to log file
echo Barcode: $BARCODE 1>>$DIR  # Write bar code to log file
echo "Date & Time: " $_now 1>>$DIR
echo 1>>$DIR
echo
# Display menu
echo "1) Run All	2) CAN		3) COM		4) USB Ports"
echo "5) Speakers	6) Cameras	7) GPS		8) Quit"
echo
echo "Choose what to test: "
read ans # Prompt user for selection

if [ "$#" -gt 1 ]; then # If more than one argument on accident
	yn=X
fi

while true; do
	case "$ans" in
		1)  #Run all tests
			bash ./src/CANbus.sh $DIR setup
			sleep 1
			bash ./src/Main_Connection.sh $DIR setup 
			sleep 1
			#bash ./src/External_Screen.sh $DIR
			bash ./src/USB_Ports.sh $DIR setup
			#bash ./src/Cameras.sh $DIR setup
			bash ./src/Speakers.sh $DIR
			bash ./src/GPS.sh $DIR setup
			echo ;;
		2)  # CANbus
			bash ./src/CANbus.sh $DIR setup
			echo ;;
		3)  # Main Connection
			bash ./src/Main_Connection.sh $DIR setup 
			echo ;;
		4)  # USB Ports
			bash ./src/USB_Ports.sh $DIR setup
			echo ;;
		5)  # Speakers
			bash ./src/Speakers.sh $DIR
			echo ;;
		6)  # Cameras
			bash ./src/Cameras.sh $DIR setup
			echo ;;
		7)  # GPS
			bash ./src/GPS.sh $DIR setup	
			echo ;;
		Q)  	break ;;
		q)	break ;;	
		*)	echo # Everything else
			echo Invalid input, try again.
			echo ;;
	esac
	echo "1) Run All	2) CAN		3) COM		4) USB Ports"
	echo "5) Speakers	6) Cameras	7) GPS		Q) Quit"
	echo
	echo "Choose what to test: "
	read ans # Prompt user for selection
	
	if [ "$#" -gt 1 ]; then # If more than one argument on accident
		yn=X
	fi
done
echo ------------------------------- END LOG ------------------------------- 1>>$DIR # Write footer to log file
echo

echo "Display test log? Y/N: "
read yn # Prompt ato display log file on exit

if [[ $yn = "Y" || $yn = "y" ]]; then
	clear
	cat $DIR	# Display log file
	echo
	echo "Press [Enter] to close"
	read 
fi
clear
