#!/usr/bin/python

import os.path
from os import path
from datetime import datetime
import argparse
parser = argparse.ArgumentParser()
parser.add_argument( '--file', action = 'store', type = str, help = 'file to parse' )
parser.add_argument( '--satfile', action = 'store', type = str, help = 'satellite data to parse' )
parser.add_argument( '--start', action = 'store', type = str, help = 'Format 2021-6-8T00:00' )
parser.add_argument( '--end', action = 'store', type = str, help = 'Format 2021-6-8T00:00 (default Now)' )
parser.add_argument( '--name', action = 'store', type = str, help = 'Name to save file as (default /var/temp/gps.png)' )
parser.add_argument( '--prns', nargs='+', type=int, help = 'Optional list of PRNs to plot (default all)')

parser.add_argument('--no-gga_quality', dest='gga_quality', action='store_false')
parser.set_defaults(gga_quality=True)
parser.add_argument('--no-gga_hdop', dest='gga_hdop', action='store_false')
parser.set_defaults(gga_hdop=True)
parser.add_argument('--no-gga_aod', dest='gga_aod', action='store_false')
parser.set_defaults(gga_aod=True)
parser.add_argument('--no-gga_numbersats', dest='gga_numbersats', action='store_false')
parser.set_defaults(gga_numbersats=True)
parser.add_argument('--no-vtg_speedKm', dest='vtg_speedKm', action='store_false')
parser.set_defaults(vtg_speedKm=True)
parser.add_argument('--no-gsv_elevation', dest='gsv_elevation', action='store_false')
parser.set_defaults(gsv_elevation=True)
parser.add_argument('--no-gsv_snr', dest='gsv_snr', action='store_false')
parser.set_defaults(gsv_snr=True)

args = parser.parse_args()

#print args

def init_list_of_objects(size):
    list_of_objects = list()
    for i in range(0,size):
        list_of_objects.append( list() ) #different object reference each time
    return list_of_objects

 
gga_quality = "0"
gga_numbersats = "0"
gga_hdop = "0"
gga_aod = "0"
gga_stnid = "0"
vtg_tracktrue = "0.0"
vtg_trackmag = "0.0"
vtg_speedKm = "0.0"
vtg_modeind = "0"
gst_latstd = "0.0"
gst_lonstd = "0.0"
gst_avgstddev = 0.0

plot_timestampList = []
plot_gga_quality = []
plot_gga_numbersats = []
plot_gga_hdop = []
plot_gga_aod = []
plot_gga_stnid = []
plot_vtg_tracktrue = []
plot_vtg_trackmag = []
plot_vtg_speedKm = []
plot_vtg_modeind = []
plot_gst_latstd = []
plot_gst_lonstd = []
plot_gst_avgstddev = []

plot_satellite_timestampList = []
plot_satellite_elev = init_list_of_objects(99)
plot_satellite_azimuth = init_list_of_objects(99)
plot_satellite_snr = init_list_of_objects(99)

prn_list = range(99)
if(args.prns != None):
    prn_list = args.prns
    
try:
    os.mkdir("/var/log/cellmon/", 0o755)
except:
    #do nothing
    pass

    
PlotFileName = "/var/log/cellmon/parsed_gps.png"
if(args.name != None):
    PlotFileName = args.name
    
PlotStartStr = "2021-6-30T14:10"
if(args.start != None):
    PlotStartStr = args.start

now = datetime.now() # current date and time
PlotEndStr = now.strftime("%Y-%m-%dT%H:%M")
if(args.end != None):
    PlotEndStr = args.end
    
PlotStart = datetime.strptime(PlotStartStr, '%Y-%m-%dT%H:%M')
PlotEnd = datetime.strptime(PlotEndStr, '%Y-%m-%dT%H:%M')

last_time_obj = PlotStart

for x in reversed(range(10)):
    if(args.file != None):
        ParseFileName = args.file
    else:
        ParseFileName = "/var/log/" + str(x)
        if(x == 0):
            ParseFileName = "/var/log/"
    
    print( "Parsing " + ParseFileName)   
   
    if(path.exists(ParseFileName)):
        # Using readlines()
        fmon = open(ParseFileName, 'r')
        Lines = fmon.readlines()

        for line in Lines:        
            splt = line.strip().split(",")
           # print(splt)
            if(len(splt) >= 4):
                datetimestr = splt[0]          
                try: 
                    date_time_obj = datetime.strptime(datetimestr, '%m/%d/%Y-%H:%M:%S.%f')                     
            #throw away any lines that aren't in our range, and any that had timestamps go backwards as those were board resets and clock hasn't synced yet        
                    if((date_time_obj >= PlotStart) and (date_time_obj <= PlotEnd) and (date_time_obj >= last_time_obj)):
                        last_time_obj = date_time_obj
                        
                        #logline = date_time_obj + gga_quality  + "," +  gga_numbersats  + "," +  gga_hdop + "," + gga_aod + "," + gga_stnid + "," + vtg_tracktrue  + "," +
                        #vtg_trackmag + "," + vtg_speedKm  + "," + vtg_modeind + "," + str(gst_latstd)  + "," + str(gst_lonstd) + "," + str(gst_avgstddev) + "\r\n"        
  
    
                        #gga_quality = splt[1]
                        #gga_numbersats = splt[2]
                        #gga_hdop = splt[3]
                        #gga_aod = splt[4]
                        #gga_stnid = splt[5]
                        #vtg_tracktrue = splt[6]
                        #vtg_trackmag = splt[7]
                        #vtg_speedKm = splt[8]
                        #vtg_modeind = splt[9]
                        #gst_latstd = splt[10]
                        #gst_lonstd = splt[11]
                        #gst_avgstddev = splt[12]
                        #print(splt)
                        
              
                        
                        plot_timestampList.append(date_time_obj)
                       
                        
                        plot_gga_quality.append(int(splt[1]))                          
                        plot_gga_numbersats.append(int(splt[2]))
                        plot_gga_hdop.append(float(splt[3]))
                        plot_gga_aod.append(int(splt[4]))                       
                        #plot_gga_stnid = []
                        plot_vtg_tracktrue.append(float(splt[6]))
                        plot_vtg_trackmag.append(float(splt[7]))
                        plot_vtg_speedKm.append(float(splt[8]))                       
                        #plot_vtg_modeind = []
                        plot_gst_latstd.append(float(splt[10]))
                        plot_gst_lonstd.append(float(splt[11]))
                        plot_gst_avgstddev.append(float(splt[12]))                       
                except:
                    print("Invalid data [" + line.strip() + "]")
                
                    
        fmon.close()
        if(args.file != None):
            break;
 
last_time_obj = PlotStart
 
for x in reversed(range(10)):
    if(args.satfile != None):
        ParseFileName = args.satfile
    else:
        ParseFileName = "/var/log/" + str(x)
        if(x == 0):
            ParseFileName = "/var/log/"
    
    print( "Parsing " + ParseFileName)   
   
    if(path.exists(ParseFileName)):
        # Using readlines()
        fmon = open(ParseFileName, 'r')
        Lines = fmon.readlines()

        for line in Lines:        
            splt = line.strip().split(",")
           # print(splt)
            if(len(splt) >= 4):
                datetimestr = splt[0]          
                try: 
                    date_time_obj = datetime.strptime(datetimestr, '%m/%d/%Y-%H:%M:%S.%f')                     
            #throw away any lines that aren't in our range, and any that had timestamps go backwards as those were board resets and clock hasn't synced yet        
                    if((date_time_obj >= PlotStart) and (date_time_obj <= PlotEnd) and (date_time_obj >= last_time_obj)):
                        last_time_obj = date_time_obj
                        
                        #logline = date_time_obj + gga_quality  + "," +  gga_numbersats  + "," +  gga_hdop + "," + gga_aod + "," + gga_stnid + "," + vtg_tracktrue  + "," +
                        #vtg_trackmag + "," + vtg_speedKm  + "," + vtg_modeind + "," + str(gst_latstd)  + "," + str(gst_lonstd) + "," + str(gst_avgstddev) + "\r\n"        
  
    
                        #gga_quality = splt[1]
                        #gga_numbersats = splt[2]
                        #gga_hdop = splt[3]
                        #gga_aod = splt[4]
                        #gga_stnid = splt[5]
                        #vtg_tracktrue = splt[6]
                        #vtg_trackmag = splt[7]
                        #vtg_speedKm = splt[8]
                        #vtg_modeind = splt[9]
                        #gst_latstd = splt[10]
                        #gst_lonstd = splt[11]
                        #gst_avgstddev = splt[12]
                        #print(splt)
                        
              
                        indexcount = int(splt[1])
                        
                        prn=0
                        elev=0
                        azimuth=0
                        snr=0
                        
                        gsv_satdict = {}
                        #gsv_satdict[prn] = [elev, azimuth, SNR]
                        for z in range(indexcount):
                            offset = z*4
                            prn=int(splt[2+offset])
 
                            if(splt[3+offset] == ""):
                                elev = 0
                            else:
                                elev=int(splt[3+offset])
  
                            if(splt[4+offset] == ""):
                                azimuth = 0
                            else:
                                azimuth=int(splt[4+offset])

                            if(splt[5+offset] == ""):
                                snr = 0
                            else:
                                snr=int(splt[5+offset])

                            gsv_satdict[prn] = [elev, azimuth, snr]                          
                                                   
                        plot_satellite_timestampList.append(date_time_obj)  

                        for k in prn_list:
                            plot_satellite_elev[k].append(gsv_satdict.get(k, [0,0,0])[0])
                            plot_satellite_azimuth[k].append(gsv_satdict.get(k, [0,0,0])[1])
                            plot_satellite_snr[k].append(gsv_satdict.get(k, [0,0,0])[2])
                            
                        gsv_satdict.clear()

                except Exception as e:
                    print e
                    print("Invalid data [" + line.strip() + "]")
                
                    
        fmon.close()
        if(args.file != None):
            break;            

import matplotlib.pyplot as plt
import matplotlib.dates as mdates
import numpy as np
import datetime as dt

plotRangeTotal = PlotEnd - PlotStart
#30 ticks fits well on a single display, convert to minutes then divide by 30
plotRangeInterval = (plotRangeTotal.total_seconds()/60) / 30

fig, ax = plt.subplots(3)
fig.set_size_inches(20,20)

#plt.gca().xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m-%dT%H:%M:%S'))
#plt.gca().xaxis.set_major_locator(mdates.MinuteLocator(interval=int(plotRangeInterval)))
plt.ion()
ax[0].xaxis.set_major_formatter(mdates.DateFormatter('%Y-%m-%dT%H:%M:%S'))

gga_min = 999999999
gga_max = -99999999
if(args.gga_quality == True):
    print("Plotting gga_quality")
    ax[0].plot(plot_timestampList,plot_gga_quality, label = "GGA Quality")
    gga_min = min(plot_gga_quality)
    gga_max = max(plot_gga_quality)
    
hdop_min = 999999999
hdop_max = -99999999
if(args.gga_hdop == True):
    print("Plotting gga_hdop")
    ax[0].plot(plot_timestampList,plot_gga_hdop, label = "GGA HDOP")
    hdop_min = min(plot_gga_hdop)
    hdop_max = max(plot_gga_hdop)

aod_min = 999999999
aod_max = -99999999
if(args.gga_aod == True):
    print("Plotting gga_aod")
    ax[0].plot(plot_timestampList,plot_gga_aod, label = "GGA AOD")
    aod_min = min(plot_gga_aod)
    aod_max = max(plot_gga_aod)

print("Plotting gst_avgstddev")
ax[0].plot(plot_timestampList,plot_gst_avgstddev, 'c', label = "GST Avg Horz StdDev")
ahsd_min = min(plot_gst_avgstddev)
ahsd_max = max(plot_gst_avgstddev)

ax[0].legend(loc='lower left', prop={'size':10})
ax[0].grid()


ax0min = min(gga_min, hdop_min, aod_min, ahsd_min) 
    
ax0max = max(gga_max, hdop_max, aod_max, ahsd_max) 
ax[0].set_ylim([ax0min - (ax0max * 0.1), ax0max + (ax0max * 0.1)])

ax[0].title.set_text("GNSS Basic Data")

sat_min = 999999999
sat_max = -99999999
if(args.gga_numbersats == True):
    print("Plotting gga_numbersats")
    #satellites subaxis on subplot
    ax01 = ax[0].twinx()
    ax01.set_ylabel('Satellites')  # we already handled the x-label with ax1
    ax01.tick_params(axis='y')
    ax01.plot(plot_timestampList,plot_gga_numbersats, 'm', label = "GGA Number Satellites")
    sat_min = min(plot_gga_numbersats)
    sat_max = max(plot_gga_numbersats)
    ax01.set_ylim([sat_min - (sat_max * 0.1), sat_max + (sat_max * 0.1)])
    ax01.legend(loc='upper right', prop={'size':10})
    ax01.grid()

#ax[1].plot(plot_timestampList,plot_vtg_tracktrue, label = "VTG TrackTrue")
#tt_min = min(plot_vtg_tracktrue)
#tt_max = max(plot_vtg_tracktrue)

#ax[1].plot(plot_timestampList,plot_vtg_trackmag, label = "VTG TragMag")
#tm_min = min(plot_vtg_trackmag)
#tm_max = max(plot_vtg_trackmag)

speed_min = 999999999
speed_max = -99999999
if(args.vtg_speedKm == True):
    print("Plotting vtg_speedKm")    
    ax[1].plot(plot_timestampList,plot_vtg_speedKm, label = "VTG SpeedKm")
    speed_min = min(plot_vtg_speedKm)
    speed_max = max(plot_vtg_speedKm)

ax[1].plot(plot_timestampList,plot_gst_avgstddev, 'c', label = "GST Avg Horz StdDev")
ahsd_min = min(plot_gst_avgstddev)
ahsd_max = max(plot_gst_avgstddev)

#ax1min = min(tt_min, tm_min, speed_min, ahsd_min) 
#ax1max = max(tt_max, tm_max, speed_max, ahsd_max) 

ax1min = min(speed_min, ahsd_min) 
ax1max = max(speed_max, ahsd_max) 

ax1max = ax1max + (ax1max * 0.1) #go 10% higher
ax[1].set_ylim([ax1min - (ax1max * 0.1), ax1max + (ax1max * 0.1)])

ax[1].legend(loc='lower left', prop={'size':10})
ax[1].grid()

ax[1].title.set_text("Speed/Heading/Accuracy")
#
#plt.plot(plot_timestampList,plot_gga_stnid, label = "GGA Station ID")
# plt.plot(plot_timestampList,plot_vtg_modeind, label = "VTG Mode Ind")
#plt.plot(plot_timestampList,plot_gst_latstd, label = "GST Lat Std")
#plt.plot(plot_timestampList,plot_gst_lonstd, label = "GST Lon Std")
#plt.plot(plot_timestampList,plot_gst_avgstddev, label = "GST Avg Std Dev")
#plt.legend(bbox_to_anchor=(0, 1), loc='lower right', ncol=1, prop={'size':6})

#plot_satellite_elev[prn].append(int(elev))
#plot_satellite_azimuth[prn].append(int(azimuth))
#plot_satellite_snr[prn].append(int(snr))

elev_min=500000
elev_max=0
plotted_prn = []
for key in prn_list:
    maxval = max(plot_satellite_elev[key])
    minval = min(plot_satellite_elev[key])
    if(maxval > 0 or args.prns != None):
        if(args.gsv_elevation == True):
            print("Plotting gsv_elevation  " + str(key))
            ax[2].plot(plot_satellite_timestampList,plot_satellite_elev[key], linestyle=':', label = str(key))
        plotted_prn.append(key)
        elev_min = min(minval, elev_min)
        elev_max = max(maxval, elev_max)
        #print(key, '->', gsv_satdict[key])

if(args.gsv_elevation == True):
    ax[2].set_ylabel('Elevation')  
    ax[2].set_ylim([elev_min - (elev_max * 0.1), elev_max + (elev_max * 0.1)])
    ax[2].grid()

if(args.gsv_elevation == False) and (args.gsv_snr == True):
    ax21 = ax[2]
elif(args.gsv_elevation == True) and (args.gsv_snr == True):
    ax21 = ax[2].twinx()
    ax21.tick_params(axis='y')  
    
if(args.gsv_snr == True):
    print("Plotting gsv_snr")
 
    snr_min=500000
    snr_max=0
    for key in plotted_prn:
        maxval = max(plot_satellite_snr[key])
        minval = min(plot_satellite_snr[key])
        ax21.plot(plot_satellite_timestampList,plot_satellite_snr[key], label = str(key))
        snr_min = min(minval, elev_min)
        snr_max = max(maxval, elev_max)
            
    ax21.set_ylabel('SNR')
    ax21.set_ylim([snr_min - (snr_max * 0.1), snr_max + (snr_max * 0.1)])
    ax21.legend(loc='upper right', prop={'size':10})
    ax21.grid()
else:
    ax[2].legend(loc='upper right', prop={'size':10})



#do these after subplot so they get drawn ontop of that data
ax[2].title.set_text("Satellite Tracking Info")
        
plt.gcf().autofmt_xdate()
plt.grid()


plt.ioff()  
print("Saving Plot to: " + PlotFileName)  
plt.savefig(PlotFileName, bbox_inches='tight')
