#!/usr/bin/python

import os
import sys
import subprocess
import threading
import re
import math
from datetime import datetime

debug = 0

stdout_result = 1
stderr_result = 1


#gps parsing variables
gpsdata = ""
last_timestamp = datetime.now()
last_log_timestamp = datetime.now()
#last_systemstamp = datetime.now()

zda_date = ""

gsv_satdict = {}

gga_quality = "0"
gga_numbersats = "0"
gga_hdop = "0"
gga_aod = "0"
gga_stnid = "0"

vtg_tracktrue = "0.0"
vtg_trackmag = "0.0"
vtg_speedKm = "0.0"
vtg_modeind = "0"

gst_latstd = "0.0"
gst_lonstd = "0.0"
gst_avgstddev = 0.0

filename = "/var/tmp/gps.raw."
filecount = 0
file = None

filesatcount = 0
filesat = None

plotname = "/var/tmp/gps."
plotcount = 0


    
def write_satellite():  
    global gsv_satdict
      
    global filesat
    global filename
    global filesatcount

    if(filesat == None):
        filesat = open(filename + str(filesatcount) +  ".sat.log", "a")
        filesatcount = filesatcount + 1

    logline = last_timestamp.strftime("%m/%d/%Y-%H:%M:%S.%f") + "," + str(len(gsv_satdict))
    
    for key in gsv_satdict:
        #print(key, '->', gsv_satdict[key])
        logline = logline + "," + str(key ) + "," + str(gsv_satdict[key][0]) + "," + str(gsv_satdict[key][1]) + "," + str(gsv_satdict[key][2])
        #print logline
    
    filesat.write(logline + "\r\n")
    filesat.flush()
    
def write_point():    
    global last_timestamp
    global gsv_satdict
    global gga_quality
    global gga_numbersats
    global gga_hdop
    global gga_aod
    global gga_stnid
    global vtg_tracktrue
    global vtg_trackmag
    global vtg_speedKm
    global vtg_modeind
    global gst_latstd
    global gst_lonstd
    global gst_avgstddev 
    
    global file
    global filename
    global filecount
    
    print file
    if(file == None):
        file = open(filename + str(filecount) +  ".log", "a")
        filecount = filecount + 1

    logline = last_timestamp.strftime("%m/%d/%Y-%H:%M:%S.%f") + "," + gga_quality  + "," +  gga_numbersats  + "," +  gga_hdop + "," + gga_aod + "," + gga_stnid + "," + vtg_tracktrue  + "," +  vtg_trackmag + "," + vtg_speedKm  + "," + vtg_modeind + "," + str(gst_latstd)  + "," + str(gst_lonstd) + "," + str(gst_avgstddev) + "\r\n"        
    
    file.write(logline)
    file.flush()
    
    #TODO:: Time duration and roll over this log?
    
def calculate_estimated_timestamp():
#    global last_systemstamp
    global last_timestamp
    
    #now = datetime.now()
    #estimated_timestamp = last_timestamp + (now - last_systemstamp) 
    
    #print "Now  " + now.strftime("%m/%d/%Y, %H:%M:%S.%f")  
    #print "Last " + last_systemstamp.strftime("%m/%d/%Y, %H:%M:%S.%f")  
    #print "ZDA  " + last_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")  
    #print "Est  " + estimated_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f") 

    #return estimated_timestamp
    
    #to keep everything monotonic consider all messages without UTC to be recieved at the same time as the previous UTC message
    #if this isn't acceptable uncomment the above estimated code but knwo its possible for time to go "backwards" by microseconds due to processing time
    return last_timestamp

def parse_gsv(data):
    global gsv_satdict
    global debug
    
    if(zda_date == ""):  #dont parse until valid date
        pass    
    elif (len(data) >= 9): 
        if(data[0] == "$GPGSV"):

                
            satelitesInMessage = (len(data) - 5) / 4    
            #print ("Processing " + str(satelitesInMessage) + " satellites")
            
            numberOfMessages = data[1]
            messageNumber = data[2]
            
            #clear out satellite list from last cycle
            if messageNumber == "1":
                gsv_satdict.clear()
                
            numberofSatellites = data[3]

            for s in range(satelitesInMessage):
                prn = data[4 + (4*s)]
                elev = data[5 + (4*s)]
                azimuth = data[6 + (4*s)]    
                SNR = data[7 + (4*s)]  
                gsv_satdict[prn] = [elev, azimuth, SNR]
            
            cksum = data[(satelitesInMessage*4) + 4]   

            if messageNumber == numberOfMessages:
                write_satellite()        
                pass
        else:
            if(debug == 1):
                print "Skipping message"
        
        timestamp = calculate_estimated_timestamp()
        if(debug == 1):
            print "Parse GSV " + messageNumber + "  "  + timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f") 
    elif (len(data) == 8):
        if(debug == 1):
            print "Parse GSV Empty"
        numberOfMessages = data[1]
        messageNumber = data[2]
        numberofSatellites = data[3]
        prn = data[4]
        elev = data[5]
        azimuth = data[6]    
#        SNR = data[6]    #TODO:: is this right??
        cksum = data[7]
    else:
        print "Invalid GSV: " + str(len(data))
        
def parse_zda(data):
    global last_timestamp
    global zda_date
    global debug
#    global last_systemstamp
    
 #   last_systemstamp = datetime.now()
    
    if (len(data) >= 8):     
        utc = data[1]
        day = data[2]
        month = data[3]
        year = data[4]
        lzd = data[5]
        lzm = data[6]
        cksum = data[7]
        
        zda_date = year + "-" + month + "-" + day
        
        datestr = zda_date + " " + utc
        last_timestamp = datetime.strptime(datestr, '%Y-%m-%d %H%M%S.%f') 
        if(debug == 1):
            print "Parse ZDA  " + last_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")
#        print "Now        " + datetime.now().strftime("%m/%d/%Y, %H:%M:%S.%f")       
    elif (len(data) == 7):
        utc = data[1]
        day = data[2]
        month = data[3]
        year = data[4]
        lzd = data[5]
        cksum = data[6]  

        zda_date = year + "-" + month + "-" + day
        
        datestr = zda_date + " " + utc
        last_timestamp = datetime.strptime(datestr, '%Y-%m-%d %H%M%S.%f')      
        if(debug == 1):
            print "Parse ZDA  " + last_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")
#        print "Now  " + datetime.now().strftime("%m/%d/%Y, %H:%M:%S.%f")
    else:
        print "Invalid ZDA: " + str(len(data))
        
def parse_gst(data):
    global last_timestamp
    global zda_date
    global debug
#    global last_systemstamp
    
    global gst_latstd
    global gst_lonstd
    global gst_avgstddev
    
 #   last_systemstamp = datetime.now()
    
    if(zda_date == ""):  #dont parse until valid date
        pass    
    elif (len(data) >= 10):
        utc = data[1]
        rms = data[2]
        smjrstd = data[3]
        smnrstd = data[4]
        orient = data[5]
        gst_latstd = data[6]
        gst_lonstd = data[7] 
        altstd = data[8] 
        cksum = data[9] 
        
        gst_avgstddev = math.sqrt(float(gst_latstd)**2 + float(gst_lonstd)**2)
        
        datestr = zda_date + " " + utc
        last_timestamp = datetime.strptime(datestr, '%Y-%m-%d %H%M%S.%f')
        if(debug == 1):
            print "Parse GST  " + last_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")        
    elif (len(data) == 9):
        print "Parse GST Empty"
        utc = data[1]
        rms = data[2]
        smjrstd = data[3]
        smnrstd = data[4]
        orient = data[5]
        gst_latstd = data[6]
        gst_lonstd = data[7] 
        cksum = data[8]         
        
        gst_avgstddev = math.sqrt(float(gst_latstd)**2 + float(gst_lonstd)**2)
    else:
        if(debug == 1):
            print "Invalid GST: " + str(len(data))

def parse_vtg(data):
    global zda_date
    global debug
    global vtg_tracktrue
    global vtg_trackmag
    global vtg_speedKm
    global vtg_modeind

    if(zda_date == ""):  #dont parse until valid date
        pass    
    elif (len(data) >= 11):
        vtg_tracktrue = data[1]
        T = data[2]
        vtg_trackmag = data[3]
        M = data[4]
        speedKn = data[5]
        N = data[6]
        vtg_speedKm = data[7] 
        K = data[8] 
        vtg_modeind = data[9]
        cksum = data[10] 
        
        timestamp = calculate_estimated_timestamp()
        if(debug == 1):
            print "Parse VGT  " + timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")
    elif (len(data) == 10):
        if(debug == 1):
            print "Parse VTG Empty"
        vtg_tracktrue = data[1]
        T = data[2]
        vtg_trackmag = data[3]
        M = data[4]
        speedKn = data[5]
        N = data[6]
        vtg_speedKm = data[7] 
        K = data[8] 
        cksum = data[9]        
        vtg_modeind = ""
    else:
        if(debug == 1):
            print "Invalid VTG: " + str(len(data))
   
def parse_gga(data):
    global last_timestamp
    global zda_date  
    global debug
#    global last_systemstamp
    
    global gga_quality
    global gga_numbersats
    global gga_hdop
    global gga_aod
    global gga_stnid

 #   last_systemstamp = datetime.now()
    
    if(zda_date == ""):  #dont parse until valid date
        pass    
    elif (len(data) >= 16):
        utc = data[1]
        lat = data[2]
        latdir = data[3]
        lon = data[4]
        londir = data[5]
        gga_quality = data[6]
        gga_numbersats = data[7] 
        gga_hdop = data[8] 
        alt = data[9]        
        units = data[10]
        undulation = data[11]
        uunits = data[12]
        gga_aod = data[13]
        
        if gga_aod == "" or gga_aod == "---":
            gga_aod = "0"
            
        gga_stnid = data[14]  
        
        if gga_stnid == "":
            gga_stnid = "0"
            
        cksum = data[15] 

        datestr = zda_date + " " + utc
        last_timestamp = datetime.strptime(datestr, '%Y-%m-%d %H%M%S.%f')   
        if(debug == 1):
            print "Parse GGA  " + last_timestamp.strftime("%m/%d/%Y, %H:%M:%S.%f")        
    elif (len(data) == 15):
        if(debug == 1):
            print "Parse GGA Empty"
        utc = data[1]
        lat = data[2]
        latdir = data[3]
        lon = data[4]
        londir = data[5]
        gga_quality = data[6]
        gga_numbersats = data[7] 
        gga_hdop = data[8] 
        alt = data[9]        
        units = data[10]
        undulation = data[11]
        uunits = data[12]
        gga_aod = data[13]  
        
        if gga_aod == "" or gga_aod == "---":
            gga_aod = "0"
            
        gga_stnid = "0"
        cksum = data[14]       
    else:
        if(debug == 1):
            print "Invalid GGA: " + str(len(data))
  
def parse_gps_string(data): 
    global debug
    global last_log_timestamp
    
    x = re.split(',|\*', data)
        
    #This isn't perfect.  This timer will run independent of the gps stream and will have 
    #a 1 second window that doesn't 100% overlap with the idential UTC flags from the gps messages
    #does this really matter?  if so we need to trigger parsing based on the utc field of the messages 
    #before the data gets stored.  We also need to make sure this is monotonic so system time changes dont 
    #break our checking

    now = datetime.now()
    graphed_delta = (now - last_log_timestamp).total_seconds() 
   
    if(graphed_delta >= 0.99):
        last_graphed_timestamp = now
  #     plot_point()            
        write_point()
    elif(graphed_delta < 0):  #time change?
        last_graphed_timestamp = now
        
#   this will print the raw split gps string
 #   print x
    if (len(x) > 2):
        message = x[0]
        if(message == "$GLGSV"):    
            #skipping GL for now as we are parsing GSV separate        
            pass
        elif "ZDA" in message:
            parse_zda(x)
        elif "GSV" in message:
            parse_gsv(x)
        elif "GST" in message:
            parse_gst(x)
        elif "VTG" in message:
            parse_vtg(x)
        elif "GGA" in message:
            parse_gga(x)  
        elif "GSA" in message:
            pass
        else:
            if(debug == 1):
                print ("Unknown message")
            
def process_gps_char(data):
    global gpsdata
#    print hex(ord(data))
    if data == '\n':
        parse_gps_string(gpsdata)
        gpsdata = ""
    else:
        gpsdata += data

def stdout_thread(pipe):
    global stdout_result
    while True:
        out = pipe.stdout.read(1)
        stdout_result = pipe.poll()
        if out == '' and stdout_result is not None:
            break

        if out != '':
            process_gps_char(out)
            #sys.stdout.write(out)
            #sys.stdout.flush()


def stderr_thread(pipe):
    global stderr_result
    while True:
        err = pipe.stderr.read(1)
        stderr_result = pipe.poll()
        if err == '' and stderr_result is not None:
            break

        if err != '':
            sys.stdout.write(err)
            sys.stdout.flush()


def exec_command(command, options, cwd=None):
    p = subprocess.Popen(
        [ command, options] , stdout=subprocess.PIPE, stderr=subprocess.PIPE, cwd=cwd
    )

    out_thread = threading.Thread(name='stdout_thread', target=stdout_thread, args=(p,))
    err_thread = threading.Thread(name='stderr_thread', target=stderr_thread, args=(p,))

    err_thread.start()
    out_thread.start()

    out_thread.join()
    err_thread.join()

    return stdout_result + stderr_result

exec_command('/usr/bin/gpspipe', '-R')
